/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import org.mule.config.i18n.CoreMessages;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class ExpressionConfig {
    public static final String CUSTOM_EVALUATOR = "custom";
    public static final String EXPRESSION_SEPARATOR = ":";
    private String expression;
    private String evaluator;
    private String customEvaluator;
    private String fullExpression;

    public ExpressionConfig() {
    }

    public ExpressionConfig(String expression, String evaluator, String customEvaluator) {
        this.customEvaluator = customEvaluator;
        this.evaluator = evaluator;
        this.expression = expression;
    }

    public void validate() {
        if (this.expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (this.evaluator == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
        }
        if (CUSTOM_EVALUATOR.equalsIgnoreCase(this.evaluator)) {
            if (this.customEvaluator == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("custom evaluator").getMessage());
            }
            this.evaluator = this.customEvaluator;
        }
        if (!ExpressionEvaluatorManager.isEvaluatorRegistered(this.evaluator)) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(this.evaluator).getMessage());
        }
    }

    public String getFullExpression() {
        if (this.fullExpression == null) {
            this.fullExpression = this.evaluator + EXPRESSION_SEPARATOR + this.expression;
        }
        return this.fullExpression;
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = customEvaluator;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

