/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TemplateParser {
    public static final String ANT_TEMPLATE_STYLE = "ant";
    public static final String SQUARE_TEMPLATE_STYLE = "square";
    public static final String CURLY_TEMPLATE_STYLE = "curly";
    protected static final Log logger = LogFactory.getLog(TemplateParser.class);
    public static final Pattern ANT_TEMPLATE_PATTERN = Pattern.compile("\\$\\{[^\\}]+\\}");
    public static final Pattern SQUARE_TEMPLATE_PATTERN = Pattern.compile("\\[[^\\]]+\\]");
    public static final Pattern CURLY_TEMPLATE_PATTERN = Pattern.compile("\\{[^\\}]+\\}");
    private final Pattern pattern;
    private final int pre;
    private final int post;
    private final String style;

    public static TemplateParser createAntStyleParser() {
        return new TemplateParser(ANT_TEMPLATE_STYLE);
    }

    public static TemplateParser createSquareBracesStyleParser() {
        return new TemplateParser(SQUARE_TEMPLATE_STYLE);
    }

    public static TemplateParser createCurlyBracesStyleParser() {
        return new TemplateParser(CURLY_TEMPLATE_STYLE);
    }

    private TemplateParser(String style) {
        if (ANT_TEMPLATE_STYLE.equals(style)) {
            this.pattern = ANT_TEMPLATE_PATTERN;
            this.pre = 2;
            this.post = 1;
        } else if (SQUARE_TEMPLATE_STYLE.equals(style)) {
            this.pattern = SQUARE_TEMPLATE_PATTERN;
            this.pre = 1;
            this.post = 1;
        } else if (CURLY_TEMPLATE_STYLE.equals(style)) {
            this.pattern = CURLY_TEMPLATE_PATTERN;
            this.pre = 1;
            this.post = 1;
        } else {
            throw new IllegalArgumentException("Unknown template style: " + style);
        }
        this.style = style;
    }

    public String parse(Map props, String template) {
        return this.parse(props, template, null);
    }

    public String parse(TemplateCallback callback, String template) {
        return this.parse(null, template, callback);
    }

    protected String parse(Map props, String template, TemplateCallback callback) {
        String result = template;
        Matcher m = this.pattern.matcher(template);
        while (m.find()) {
            Object value = null;
            String match = m.group();
            String propname = match.substring(this.pre, match.length() - this.post);
            if (callback != null) {
                value = callback.match(propname);
            } else if (props != null) {
                value = props.get(propname);
            }
            if (value == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Value " + propname + " not found in context"));
                continue;
            }
            String matchRegex = this.escape(match);
            String valueString = value.toString();
            if (valueString.indexOf(92) != -1) {
                valueString = valueString.replaceAll("\\\\", "\\\\\\\\");
            }
            result = result.replaceAll(matchRegex, valueString);
        }
        return result;
    }

    public List parse(Map props, List templates) {
        if (templates == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>(templates.size());
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            list.add(this.parse(props, iterator.next().toString()));
        }
        return list;
    }

    public Map parse(final Map props, Map templates) {
        return this.parse(new TemplateCallback(){

            public Object match(String token) {
                return props.get(token);
            }
        }, templates);
    }

    public Map parse(TemplateCallback callback, Map templates) {
        if (templates == null) {
            return new HashMap();
        }
        HashMap map = new HashMap(templates.size());
        for (Map.Entry entry : templates.entrySet()) {
            map.put(entry.getKey(), this.parse(callback, entry.getValue().toString()));
        }
        return map;
    }

    private String escape(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char currentCharacter = string.charAt(i);
            switch (currentCharacter) {
                case '$': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    buffer.append("\\");
                }
            }
            buffer.append(currentCharacter);
        }
        return buffer.toString();
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isContainsTemplate(String value) {
        if (value == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(value);
        return m.find();
    }

    public static interface TemplateCallback {
        public Object match(String var1);
    }
}

