/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;

public class TransformerUtils {
    public static final String COMMA = ",";
    private static Log logger = LogFactory.getLog(AbstractTransformer.class);

    public static void initialiseAllTransformers(List transformers) throws InitialisationException {
        if (transformers != null) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                ((Transformer)transformer.next()).initialise();
            }
        }
    }

    public static String toString(List transformers) {
        StringBuffer buffer = new StringBuffer();
        Iterator transformer = transformers.iterator();
        while (transformer.hasNext()) {
            buffer.append(transformer.next().toString());
            if (!transformer.hasNext()) continue;
            buffer.append(" -> ");
        }
        return buffer.toString();
    }

    public static Transformer firstOrNull(List transformers) {
        if (transformers != null && 0 != transformers.size()) {
            return (Transformer)transformers.get(0);
        }
        return null;
    }

    public static boolean isSourceTypeSupportedByFirst(List transformers, Class clazz) {
        Transformer transformer = TransformerUtils.firstOrNull(transformers);
        return null != transformer && transformer.isSourceTypeSupported(clazz);
    }

    protected static List getTransformersFromSource(TransformerSource source) {
        try {
            List transformers = source.getTransformers();
            TransformerUtils.initialiseAllTransformers(transformers);
            return transformers;
        }
        catch (MuleException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List getDefaultInboundTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createInboundTransformers();
            }
        });
    }

    public static List getDefaultResponseTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createResponseTransformers();
            }
        });
    }

    public static List getDefaultOutboundTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createOutboundTransformers();
            }
        });
    }

    public static List getTransformers(String names) throws DefaultMuleException {
        if (null != names) {
            LinkedList<Transformer> transformers = new LinkedList<Transformer>();
            StringTokenizer st = new StringTokenizer(names, COMMA);
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                Transformer transformer = RegistryContext.getRegistry().lookupTransformer(key);
                if (transformer == null) {
                    throw new DefaultMuleException(CoreMessages.objectNotRegistered("Transformer", key));
                }
                transformers.add(transformer);
            }
            return transformers;
        }
        return null;
    }

    protected static interface TransformerSource {
        public List getTransformers() throws TransportFactoryException;
    }
}

