/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;

public class MulticastingRouter
extends FilteringOutboundRouter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        MuleMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(this.endpoints.size());
            }
        }
        try {
            List list = this.endpoints;
            synchronized (list) {
                for (int i = 0; i < this.endpoints.size(); ++i) {
                    OutboundEndpoint endpoint = (OutboundEndpoint)this.endpoints.get(i);
                    if (endpoint.isSynchronous()) {
                        if (result == null) {
                            result = this.send(session, message, endpoint);
                            continue;
                        }
                        String def = (String)endpoint.getProperties().get("default");
                        if (def != null) {
                            result = this.send(session, message, endpoint);
                            continue;
                        }
                        this.send(session, message, endpoint);
                        continue;
                    }
                    this.dispatch(session, message, endpoint);
                }
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, (ImmutableEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return result;
    }
}

