/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.routing.AbstractRouterCollection;
import org.mule.transaction.TransactionTemplate;

public class DefaultOutboundRouterCollection
extends AbstractRouterCollection
implements OutboundRouterCollection {
    public DefaultOutboundRouterCollection() {
        super(2);
    }

    public MuleMessage route(final MuleMessage message, final MuleSession session) throws MessagingException {
        boolean matchfound = false;
        for (OutboundRouter umoOutboundRouter : this.getRouters()) {
            MuleMessage result;
            if (!umoOutboundRouter.isMatch(message)) continue;
            matchfound = true;
            final OutboundRouter router = umoOutboundRouter;
            TransactionTemplate tt = new TransactionTemplate(umoOutboundRouter.getTransactionConfig(), session.getService().getExceptionListener(), this.muleContext);
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    return router.route(message, session);
                }
            };
            try {
                result = (MuleMessage)tt.execute(cb);
            }
            catch (Exception e) {
                throw new RoutingException(message, null, (Throwable)e);
            }
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + session.getService().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(message, session);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + session.getService().getName() + " and there is no catch all strategy configured on this router.  Disposing message " + message));
        }
        return message;
    }

    protected MuleMessage catchAll(MuleMessage message, MuleSession session) throws RoutingException {
        if (this.getStatistics().isEnabled()) {
            this.getStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().catchMessage(message, session);
    }

    public boolean hasEndpoints() {
        for (OutboundRouter router : this.routers) {
            if (router.getEndpoints().size() <= 0 && !router.isDynamicEndpoints()) continue;
            return true;
        }
        return false;
    }
}

