/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class AutoConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    protected static final Log logger = LogFactory.getLog(AutoConfigurationBuilder.class);

    public AutoConfigurationBuilder(String resource) throws ConfigurationException {
        super(resource);
    }

    public AutoConfigurationBuilder(String[] resources) throws ConfigurationException {
        super(resources);
    }

    public AutoConfigurationBuilder(ConfigResource[] resources) {
        super(resources);
    }

    protected void doConfigure(MuleContext muleContext) throws ConfigurationException {
        this.autoConfigure(muleContext, this.configResources);
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
    }

    protected void autoConfigure(MuleContext muleContext, ConfigResource[] configResources) throws ConfigurationException {
        LinkedHashMap<String, ArrayList<ConfigResource>> configsMap = new LinkedHashMap<String, ArrayList<ConfigResource>>();
        for (int i = 0; i < configResources.length; ++i) {
            String configExtension = StringUtils.substringAfterLast((String)configResources[i].getUrl().getFile(), (String)".");
            ArrayList<ConfigResource> configs = (ArrayList<ConfigResource>)configsMap.get(configExtension);
            if (configs == null) {
                configs = new ArrayList<ConfigResource>();
                configsMap.put(configExtension, configs);
            }
            configs.add(configResources[i]);
        }
        try {
            Properties props = new Properties();
            props.load(ClassUtils.getResource("configuration-builders.properties", this.getClass()).openStream());
            for (Map.Entry e : configsMap.entrySet()) {
                String extension = (String)e.getKey();
                List configs = (List)e.getValue();
                String className = (String)props.get(extension);
                if (className == null || !ClassUtils.isClassOnPath(className, this.getClass())) {
                    throw new ConfigurationException(CoreMessages.configurationBuilderNoMatching(this.createConfigResourcesString()));
                }
                ConfigResource[] constructorArg = new ConfigResource[configs.size()];
                System.arraycopy(configs.toArray(), 0, constructorArg, 0, configs.size());
                ConfigurationBuilder cb = (ConfigurationBuilder)ClassUtils.instanciateClass(className, new Object[]{constructorArg});
                cb.configure(muleContext);
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

