/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.security.SecurityException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnectable;

public abstract class AbstractMessageDispatcher
extends AbstractConnectable
implements MessageDispatcher {
    public AbstractMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public final void dispatch(MuleEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        event = OptimizedRequestContext.criticalSetEvent(event);
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.connector.handleException(e);
                return;
            }
            catch (MuleException e) {
                this.disposeAndLogException();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        try {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            Worker worker = new Worker(event);
            if (this.isDoThreading() && !event.isSynchronous() && tx == null) {
                this.connector.getDispatcherWorkManager().scheduleWork(new Worker(event), Long.MAX_VALUE, null, this.connector);
            } else {
                worker.run();
            }
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public final MuleMessage send(MuleEvent event) throws DispatchException {
        if (this.isTransactionRollback()) {
            return event.getMessage();
        }
        event.setSynchronous(true);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().getUri().toString());
        event = OptimizedRequestContext.unsafeSetEvent(event);
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.connector.handleException(e);
                return event.getMessage();
            }
            catch (MuleException e) {
                this.disposeAndLogException();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        final MuleEvent finalEvent = event;
        try {
            RetryContext context = this.retryTemplate.execute(new RetryCallback(){

                public void doWork(RetryContext context) throws Exception {
                    AbstractMessageDispatcher.this.connect();
                    MuleMessage result = AbstractMessageDispatcher.this.doSend(finalEvent);
                    if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                        String component = null;
                        if (finalEvent.getService() != null) {
                            component = finalEvent.getService().getName();
                        }
                        AbstractMessageDispatcher.this.connector.fireNotification(new EndpointMessageNotification(finalEvent.getMessage(), finalEvent.getEndpoint(), component, 803));
                    }
                    context.addReturnMessage(result);
                }

                public String getWorkDescription() {
                    return AbstractMessageDispatcher.this.getConnectionDescription();
                }
            });
            return context.getFirstReturnMessage();
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected boolean useRemoteSync(MuleEvent event) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isRemoteSyncEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isRemoteSync() || event.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", false);
            if (remoteSync && event.getService() != null) {
                ResponseRouterCollection responseRouters = event.getService().getResponseRouter();
                remoteSync = responseRouters == null || !responseRouters.hasEndpoints();
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    protected boolean isTransactionRollback() {
        try {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (tx != null && tx.isRollbackOnly()) {
                return true;
            }
        }
        catch (TransactionException e) {
            this.logger.warn((Object)e.getMessage());
        }
        return false;
    }

    protected abstract void doDispatch(MuleEvent var1) throws Exception;

    protected abstract MuleMessage doSend(MuleEvent var1) throws Exception;

    private class Worker
    implements Work {
        private MuleEvent event;

        public Worker(MuleEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                AbstractMessageDispatcher.this.retryTemplate.execute(new RetryCallback(){

                    public void doWork(RetryContext context) throws Exception {
                        MuleEvent finalEvent = RequestContext.setEvent(Worker.this.event);
                        AbstractMessageDispatcher.this.connect();
                        AbstractMessageDispatcher.this.doDispatch(finalEvent);
                        if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                            String component = null;
                            if (finalEvent.getService() != null) {
                                component = finalEvent.getService().getName();
                            }
                            AbstractMessageDispatcher.this.connector.fireNotification(new EndpointMessageNotification(finalEvent.getMessage(), finalEvent.getEndpoint(), component, 802));
                        }
                    }

                    public String getWorkDescription() {
                        return AbstractMessageDispatcher.this.getConnectionDescription();
                    }
                });
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

