/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.context.notification.ConnectionNotification;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractConnectable
implements Connectable,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected RetryPolicyTemplate retryTemplate;
    private WorkManager workManager = null;
    protected final AtomicBoolean connecting = new AtomicBoolean(false);
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean stopped = new WaitableBoolean(true);
    protected boolean asyncConnections = false;
    protected boolean startOnConnect = false;

    public AbstractConnectable(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
    }

    protected void disposeAndLogException() {
        try {
            this.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Could not dispose of the message dispatcher!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.getConnector().handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public boolean validate() {
        return !this.disposed.get();
    }

    public void activate() {
    }

    public void passivate() {
    }

    public final void initialise() throws InitialisationException {
        this.retryTemplate = this.endpoint.getRetryPolicyTemplate() != null ? this.endpoint.getRetryPolicyTemplate() : this.connector.getRetryPolicyTemplate();
        this.doInitialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.disposed.get()) {
            try {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                this.disposing.set(true);
                this.doDispose();
            }
            finally {
                this.disposed.set(true);
            }
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public final synchronized void connect() throws Exception {
        if (this.disposed.get()) {
            throw new IllegalStateException("Requester/dispatcher has been disposed; cannot connect to resource");
        }
        RetryCallback callback = new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                AbstractConnectable.this.doConnect();
                AbstractConnectable.this.connected.set(true);
                if (AbstractConnectable.this.startOnConnect) {
                    AbstractConnectable.this.start();
                }
            }

            public String getWorkDescription() {
                return AbstractConnectable.this.getConnectionDescription();
            }
        };
        this.retryTemplate.execute(callback);
        if (this.startOnConnect) {
            this.start();
        }
    }

    public final synchronized void disconnect() throws Exception {
        if (!this.connected.get()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected.set(false);
        this.logger.info((Object)("Disconnected: " + this));
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(ImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI().getUri() + ")";
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    public String getConnectionDescription() {
        return "endpoint.outbound." + this.endpoint.getEndpointURI().toString();
    }

    public synchronized void reconnect() throws Exception {
        this.disconnect();
        this.connect();
    }

    public final void start() throws MuleException {
        if (!this.connected.get()) {
            this.startOnConnect = true;
            return;
        }
        if (this.stopped.compareAndSet(true, false)) {
            this.doStart();
        }
    }

    public final void stop() {
        try {
            if (this.connected.get()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.doStop();
            }
            catch (MuleException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI().getUri());
        sb.append(", disposed=").append(this.disposed);
        sb.append('}');
        return sb.toString();
    }

    protected WorkManager getWorkManager() {
        return this.workManager;
    }

    protected void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        this.endpoint = endpoint;
    }
}

