/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class TransformerCollection
extends AbstractMessageAwareTransformer {
    private List transformers;

    public TransformerCollection(List transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = transformers;
    }

    public TransformerCollection(Transformer[] transformers) {
        if (transformers.length < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = Arrays.asList(transformers);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage result = message;
        Object temp = message;
        Transformer lastTransformer2 = null;
        for (Transformer lastTransformer2 : this.transformers) {
            temp = lastTransformer2.transform(temp);
            if (temp instanceof MuleMessage) {
                result = (MuleMessage)temp;
                continue;
            }
            result.setPayload(temp);
        }
        if (lastTransformer2 != null && lastTransformer2.getReturnClass().equals(MuleMessage.class)) {
            return result;
        }
        return result.getPayload();
    }
}

