/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.interceptor.Invocation;

public class TimerInterceptor
implements Interceptor {
    private static Log logger = LogFactory.getLog(TimerInterceptor.class);

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        long startTime = System.currentTimeMillis();
        MuleMessage result = invocation.invoke();
        if (logger.isInfoEnabled()) {
            long executionTime = System.currentTimeMillis() - startTime;
            logger.info((Object)(invocation.getService().getName() + " took " + executionTime + "ms to process event [" + invocation.getEvent().getId() + "]"));
        }
        return result;
    }
}

