/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mule.api.transport.PropertyScope;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

public class MessagePropertiesContext
implements Serializable {
    protected Map scopedMap;
    protected Set keySet;
    Map applicationProperties = new ConcurrentHashMap(0);
    private PropertyScope defaultScope = PropertyScope.OUTBOUND;
    private boolean fallbackToRegistry = false;

    public MessagePropertiesContext() {
        this.keySet = new TreeSet();
        this.scopedMap = new TreeMap(new PropertyScope.ScopeComarator());
        this.scopedMap.put(PropertyScope.INVOCATION, new HashMap(6));
        this.scopedMap.put(PropertyScope.INBOUND, new HashMap(6));
        this.scopedMap.put(PropertyScope.OUTBOUND, new HashMap(6));
        this.scopedMap.put(PropertyScope.SESSION, new HashMap(6));
    }

    public MessagePropertiesContext(PropertyScope defaultScope) {
        this();
        this.checkScopeForWriteAccess(defaultScope);
        this.defaultScope = defaultScope;
    }

    protected Map getScopedProperties(PropertyScope scope) {
        Map map = (Map)this.scopedMap.get(scope);
        if (map == null) {
            throw new IllegalArgumentException("Scope not registered: " + scope);
        }
        return map;
    }

    void registerInvocationProperties(Map properties) {
        if (properties != null) {
            this.getScopedProperties(PropertyScope.INVOCATION).putAll(properties);
            this.keySet.addAll(properties.keySet());
        }
    }

    public PropertyScope getDefaultScope() {
        return this.defaultScope;
    }

    void addInboundProperties(Map properties) {
        if (properties != null) {
            this.getScopedProperties(PropertyScope.INBOUND).putAll(properties);
            this.keySet.addAll(properties.keySet());
        }
    }

    void registerSessionProperties(Map properties) {
        if (properties != null) {
            this.getScopedProperties(PropertyScope.SESSION).putAll(properties);
            this.keySet.addAll(properties.keySet());
        }
    }

    public Object getProperty(String key) {
        Map props;
        Object value = null;
        Iterator iterator = this.scopedMap.values().iterator();
        while (iterator.hasNext() && (value = (props = (Map)iterator.next()).get(key)) == null) {
        }
        if (value == null && this.fallbackToRegistry) {
            value = this.applicationProperties.get(key);
        }
        return value;
    }

    public Object getProperty(String key, PropertyScope scope) {
        if (PropertyScope.APPLICATION.equals(scope)) {
            return this.applicationProperties.get(key);
        }
        Map props = this.getScopedProperties(scope);
        return props.get(key);
    }

    public void clearProperties() {
        Map props = this.getScopedProperties(PropertyScope.INVOCATION);
        this.keySet.removeAll(props.keySet());
        props.clear();
        props = this.getScopedProperties(PropertyScope.OUTBOUND);
        this.keySet.removeAll(props.keySet());
        props.clear();
        props = this.getScopedProperties(PropertyScope.SESSION);
        this.keySet.removeAll(props.keySet());
        props.clear();
    }

    public void clearProperties(PropertyScope scope) {
        this.checkScopeForWriteAccess(scope);
        Map props = this.getScopedProperties(scope);
        this.keySet.removeAll(props.keySet());
        props.clear();
    }

    public Object removeProperty(String key) {
        Object value = this.getScopedProperties(PropertyScope.INVOCATION).remove(key);
        if (value == null) {
            value = this.getScopedProperties(PropertyScope.OUTBOUND).remove(key);
        }
        if (value == null) {
            value = this.getScopedProperties(PropertyScope.SESSION).remove(key);
        }
        if (value != null) {
            this.keySet.remove(key);
        }
        return value;
    }

    public void setProperty(String key, Object value) {
        this.getScopedProperties(this.defaultScope).put(key, value);
        this.keySet.add(key);
    }

    public void setProperty(String key, Object value, PropertyScope scope) {
        this.checkScopeForWriteAccess(scope);
        this.getScopedProperties(scope).put(key, value);
        this.keySet.add(key);
    }

    public Set getPropertyNames() {
        return Collections.unmodifiableSet(this.keySet);
    }

    public Set getPropertyNames(PropertyScope scope) {
        return Collections.unmodifiableSet(this.getScopedProperties(scope).keySet());
    }

    protected void checkScopeForWriteAccess(PropertyScope scope) {
        if (scope == null || PropertyScope.INBOUND.equals(scope) || PropertyScope.APPLICATION.equals(scope)) {
            throw new IllegalArgumentException("Scope is invalid for writing properties: " + scope);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public byte getByteProperty(String name, byte defaultValue) {
        return ObjectUtils.getByte(this.getProperty(name), defaultValue);
    }

    public short getShortProperty(String name, short defaultValue) {
        return ObjectUtils.getShort(this.getProperty(name), defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return ObjectUtils.getInt(this.getProperty(name), defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return ObjectUtils.getLong(this.getProperty(name), defaultValue);
    }

    public float getFloatProperty(String name, float defaultValue) {
        return ObjectUtils.getFloat(this.getProperty(name), defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return ObjectUtils.getDouble(this.getProperty(name), defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return ObjectUtils.getBoolean(this.getProperty(name), defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        return ObjectUtils.getString(this.getProperty(name), defaultValue);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("Properites{");
        for (Map.Entry entry : this.scopedMap.entrySet()) {
            buf.append(entry.getKey()).append(":");
            buf.append(MapUtils.toString((Map)entry.getValue(), false));
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

