/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;

public final class TransactionCoordination {
    protected static final Log logger = LogFactory.getLog(TransactionCoordination.class);
    private static final TransactionCoordination instance = new TransactionCoordination();
    private static final ThreadLocal transactions = new ThreadLocal();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        return instance;
    }

    public Transaction getTransaction() {
        return (Transaction)transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(Transaction transaction) throws TransactionException {
        try {
            Transaction oldTx = (Transaction)transactions.get();
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionCannotUnbind());
            }
        }
        finally {
            transactions.set(null);
            TransactionCoordination transactionCoordination = this;
            synchronized (transactionCoordination) {
                if (this.txCounter > 0) {
                    --this.txCounter;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = (Transaction)transactions.get();
        if (oldTx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
        }
        transactions.set(transaction);
        TransactionCoordination transactionCoordination = this;
        synchronized (transactionCoordination) {
            ++this.txCounter;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding new transaction (" + this.txCounter + ") " + transaction));
            }
        }
    }
}

