/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractRecipientList
extends FilteringOutboundRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConcurrentMap recipientCache = new ConcurrentHashMap();
    private Boolean synchronous;

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        if (this.synchronous != null) {
            synchronous = this.synchronous;
        }
        List recipients = this.getRecipients(message);
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationGroupSize() != -1;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(recipients.size());
            }
        }
        MuleMessage result = null;
        for (Object recipient : recipients) {
            DefaultMuleMessage request = new DefaultMuleMessage(message.getPayload(), message);
            OutboundEndpoint endpoint = this.getRecipientEndpoint(request, recipient);
            try {
                if (synchronous) {
                    result = this.send(session, request, endpoint);
                    if (result != null) {
                        results.add(result.getPayload());
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("No result was returned for sync call to: " + endpoint.getEndpointURI()));
                    continue;
                }
                this.dispatch(session, request, endpoint);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(request, endpoint, (Throwable)e);
            }
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return new DefaultMuleMessage(results.get(0), result);
        }
        return new DefaultMuleMessage(results, result);
    }

    protected OutboundEndpoint getRecipientEndpoint(MuleMessage message, Object recipient) throws RoutingException {
        OutboundEndpoint endpoint = null;
        try {
            if (recipient instanceof EndpointURI) {
                endpoint = this.getRecipientEndpointFromUri((EndpointURI)recipient);
            } else if (recipient instanceof String) {
                endpoint = this.getRecipientEndpointFromString(message, (String)recipient);
            }
            if (null == endpoint) {
                throw new RegistrationException("Failed to create endpoint for: " + recipient);
            }
            OutboundEndpoint existingEndpoint = (OutboundEndpoint)this.recipientCache.putIfAbsent(recipient, (Object)endpoint);
            if (existingEndpoint != null) {
                endpoint = existingEndpoint;
            }
        }
        catch (MuleException e) {
            throw new RoutingException(message, endpoint, (Throwable)e);
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromUri(EndpointURI uri) throws MuleException {
        OutboundEndpoint endpoint = null;
        if (null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri.getAddress());
        }
        if (null != endpoint) {
            MuleServer.getMuleContext().applyLifecycle(endpoint);
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromString(MuleMessage message, String recipient) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.recipientCache.get((Object)recipient);
        if (null == endpoint && null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(recipient);
        }
        return endpoint;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isDynamicEndpoints() {
        return true;
    }

    protected abstract List getRecipients(MuleMessage var1);
}

