/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import org.mule.api.management.stats.Statistics;
import org.mule.management.stats.printers.SimplePrinter;

public class ComponentStatistics
implements Statistics {
    private static final long serialVersionUID = -2086999226732861674L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long averageExecutionTime = 0L;
    private long executedEvent = 0L;
    private long totalExecTime = 0L;
    private boolean enabled = false;

    public void clear() {
        this.minExecutionTime = 0L;
        this.maxExecutionTime = 0L;
        this.executedEvent = 0L;
        this.totalExecTime = 0L;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecTime;
    }

    public long getExecutedEvents() {
        return this.executedEvent;
    }

    public synchronized void addExecutionTime(long time) {
        ++this.executedEvent;
        this.totalExecTime += time == 0L ? 1L : time;
        if (this.minExecutionTime == 0L || time < this.minExecutionTime) {
            this.minExecutionTime = time;
        }
        if (this.maxExecutionTime == 0L || time > this.maxExecutionTime) {
            this.maxExecutionTime = time;
        }
        this.averageExecutionTime = Math.round(this.totalExecTime / this.executedEvent);
    }

    public long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }
}

