/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.ImmutableEndpoint;

public class MessageNotification
extends ServerNotification {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Log logger = LogFactory.getLog(MessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_DISPATCHED = 802;
    public static final int MESSAGE_SENT = 803;
    public static final int MESSAGE_REQUESTED = 804;
    private ImmutableEndpoint endpoint;

    public MessageNotification(MuleMessage resource, ImmutableEndpoint endpoint, String identifier, int action) {
        super(MessageNotification.cloneMessage(resource), action);
        this.resourceIdentifier = identifier;
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MuleMessage cloneMessage(MuleMessage message) {
        MuleMessage muleMessage = message;
        synchronized (muleMessage) {
            return new DefaultMuleMessage(message.getPayload(), message);
        }
    }

    protected String getPayloadToString() {
        try {
            return ((MuleMessage)this.source).getPayloadAsString();
        }
        catch (Exception e) {
            return this.source.toString();
        }
    }

    public String toString() {
        return this.EVENT_NAME + "{action=" + MessageNotification.getActionName(this.action) + ", endpoint: " + this.endpoint.getEndpointURI() + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    static {
        MessageNotification.registerAction("received", 801);
        MessageNotification.registerAction("dispatched", 802);
        MessageNotification.registerAction("sent", 803);
        MessageNotification.registerAction("requested", 804);
    }
}

