/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.routing;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class ServiceRoutingException
extends RoutingException {
    private static final long serialVersionUID = -113944443831267318L;
    private transient Service service;

    public ServiceRoutingException(Message message, MuleMessage umoMessage, ImmutableEndpoint endpoint, Service service) {
        super(ServiceRoutingException.generateMessage(message, endpoint, service), umoMessage, endpoint);
        this.service = service;
    }

    public ServiceRoutingException(Message message, MuleMessage umoMessage, ImmutableEndpoint endpoint, Service service, Throwable cause) {
        super(ServiceRoutingException.generateMessage(message, endpoint, service), umoMessage, endpoint, cause);
        this.service = service;
    }

    public ServiceRoutingException(MuleMessage umoMessage, ImmutableEndpoint endpoint, Service service) {
        super(ServiceRoutingException.generateMessage(null, endpoint, service), umoMessage, endpoint);
        this.service = service;
    }

    public ServiceRoutingException(MuleMessage umoMessage, ImmutableEndpoint endpoint, Service service, Throwable cause) {
        super(ServiceRoutingException.generateMessage(null, endpoint, service), umoMessage, endpoint, cause);
        this.service = service;
    }

    private static Message generateMessage(Message message, ImmutableEndpoint endpoint, Service service) {
        Message m = CoreMessages.routingFailedOnEndpoint(service.getName(), endpoint.getEndpointURI());
        if (message != null) {
            message.setNextMessage(m);
            return message;
        }
        return m;
    }

    public Service getService() {
        return this.service;
    }
}

