/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.expression.ExpressionEvaluatorManager;
import org.mule.util.expression.ExpressionRuntimeException;

public class ExpressionTransformer
extends AbstractMessageAwareTransformer {
    private List arguments;

    public ExpressionTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
        this.arguments = new ArrayList(4);
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public boolean removeArgument(Argument argument) {
        return this.arguments.remove(argument);
    }

    public void initialise() throws InitialisationException {
        if (this.arguments == null || this.arguments.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("arguments[]"), (Initialisable)this);
        }
        for (Argument argument : this.arguments) {
            try {
                argument.validate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object[] results = new Object[this.arguments.size()];
        int i = 0;
        for (Argument argument : this.arguments) {
            try {
                results[i] = ExpressionEvaluatorManager.evaluate(argument.getFullExpression(), message);
            }
            catch (ExpressionRuntimeException e) {
                throw new TransformerException(this, (Throwable)e);
            }
            if (!argument.isOptional() && results[i] == null) {
                throw new TransformerException(CoreMessages.expressionEvaluatorReturnedNull(argument.getEvaluator(), argument.getExpression()), this);
            }
            ++i;
        }
        if (results.length == 1) {
            return results[0];
        }
        return results;
    }

    public List getArguments() {
        return this.arguments;
    }

    public void setArguments(List arguments) {
        this.arguments = arguments;
    }

    public static class Argument {
        public static final String EVAL_TOKEN = ":";
        private String expression;
        private String evaluator;
        private String customEvaluator;
        private boolean optional;

        public String getCustomEvaluator() {
            return this.customEvaluator;
        }

        public void setCustomEvaluator(String customEvaluator) {
            this.customEvaluator = customEvaluator;
        }

        public String getEvaluator() {
            return this.evaluator;
        }

        public void setEvaluator(String evaluator) {
            this.evaluator = evaluator;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        protected String getFullExpression() {
            if (!this.optional && (this.evaluator.equals("headers") || this.evaluator.equals("headers-list") || this.evaluator.equals("attachments") || this.evaluator.equals("attachments-list"))) {
                return this.evaluator + EVAL_TOKEN + this.expression + "required";
            }
            return this.evaluator + EVAL_TOKEN + this.expression;
        }

        protected void validate() {
            if (this.expression == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
            }
            if (this.evaluator == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
            }
            if (this.evaluator.equals("custom")) {
                if (this.customEvaluator == null) {
                    throw new IllegalArgumentException(CoreMessages.objectIsNull("customEvaluator").getMessage());
                }
                this.evaluator = this.customEvaluator;
            }
            if (!ExpressionEvaluatorManager.isEvaluatorRegistered(this.evaluator)) {
                throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(this.evaluator).getMessage());
            }
        }
    }
}

