/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.compression.GZipCompressTransformer;
import org.mule.util.IOUtils;

public class GZipUncompressTransformer
extends GZipCompressTransformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] buffer = null;
        try {
            byte[] input = null;
            if (src instanceof InputStream) {
                InputStream inputStream = (InputStream)src;
                try {
                    input = IOUtils.toByteArray(inputStream);
                }
                finally {
                    inputStream.close();
                }
            } else {
                input = (byte[])src;
            }
            buffer = this.getStrategy().uncompressByteArray(input);
        }
        catch (IOException e) {
            throw new TransformerException(MessageFactory.createStaticMessage("Failed to uncompress message."), this, (Throwable)e);
        }
        if (!this.getReturnClass().equals(byte[].class)) {
            return SerializationUtils.deserialize((byte[])buffer);
        }
        return buffer;
    }
}

