/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.transaction.constraints.ConstraintFilter;
import org.mule.util.ClassUtils;

public class MuleTransactionConfig
implements TransactionConfig {
    protected static final Log logger = LogFactory.getLog(MuleTransactionConfig.class);
    public static final String ACTION_NONE_STRING = "NONE";
    public static final String ACTION_ALWAYS_BEGIN_STRING = "ALWAYS_BEGIN";
    public static final String ACTION_BEGIN_OR_JOIN_STRING = "BEGIN_OR_JOIN";
    public static final String ACTION_ALWAYS_JOIN_STRING = "ALWAYS_JOIN";
    public static final String ACTION_JOIN_IF_POSSIBLE_STRING = "JOIN_IF_POSSIBLE";
    private TransactionFactory factory;
    private byte action = 0;
    private ConstraintFilter constraint = null;
    private int timeout;

    public TransactionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(TransactionFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Transaction Factory cannot be null");
        }
        this.factory = factory;
    }

    public byte getAction() {
        return this.action;
    }

    public void setAction(byte action) {
        this.action = action;
    }

    public void setActionAsString(String action) {
        if (ACTION_ALWAYS_BEGIN_STRING.equals(action)) {
            this.action = 1;
        } else if (ACTION_BEGIN_OR_JOIN_STRING.equals(action)) {
            this.action = (byte)2;
        } else if (ACTION_ALWAYS_JOIN_STRING.equals(action)) {
            this.action = (byte)3;
        } else if (ACTION_JOIN_IF_POSSIBLE_STRING.equals(action)) {
            this.action = (byte)4;
        } else if (ACTION_NONE_STRING.equals(action)) {
            this.action = 0;
        } else {
            throw new IllegalArgumentException("Action " + action + " is not recognised as a begin action.");
        }
    }

    public String getActionAsString() {
        switch (this.action) {
            case 1: {
                return ACTION_ALWAYS_BEGIN_STRING;
            }
            case 2: {
                return ACTION_BEGIN_OR_JOIN_STRING;
            }
            case 3: {
                return ACTION_ALWAYS_JOIN_STRING;
            }
            case 4: {
                return ACTION_JOIN_IF_POSSIBLE_STRING;
            }
        }
        return ACTION_NONE_STRING;
    }

    public boolean isTransacted() {
        return this.factory != null && this.factory.isTransacted() && this.action != 0;
    }

    public ConstraintFilter getConstraint() {
        if (this.constraint == null) {
            return null;
        }
        try {
            return (ConstraintFilter)this.constraint.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.fatal((Object)("Failed to clone ContraintFilter: " + e.getMessage()), (Throwable)e);
            return this.constraint;
        }
    }

    public void setConstraint(ConstraintFilter constraint) {
        this.constraint = constraint;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Transaction{factory=").append(this.factory).append(", action=").append(this.getActionAsString()).append(", timeout=").append(this.timeout).append("}");
        return buf.toString();
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.factory, new Byte(this.action), this.constraint, new Integer(this.timeout)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MuleTransactionConfig other = (MuleTransactionConfig)obj;
        return ClassUtils.equal(this.factory, other.factory) && ClassUtils.equal(new Byte(this.action), new Byte(other.action)) && ClassUtils.equal(this.constraint, other.constraint) && ClassUtils.equal(new Integer(this.timeout), new Integer(other.timeout));
    }
}

