/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.LinkedList;
import org.mule.DefaultMuleEvent;
import org.mule.MuleServer;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.AggregationException;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;

public abstract class AbstractEventAggregator
extends SelectiveConsumer {
    public static final String NO_CORRELATION_ID = "no-id";
    private final ConcurrentMap eventGroups = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        EventGroup group;
        MuleEvent[] result = null;
        if (!this.isMatch(event)) return result;
        boolean miss = false;
        Object groupId = this.getEventGroupIdForEvent(event);
        while (true) {
            if (miss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((group = this.getEventGroup(groupId)) == null) {
                group = this.addEventGroup(this.createEventGroup(event, groupId));
            }
            EventGroup eventGroup = group;
            synchronized (eventGroup) {
                if (group == this.getEventGroup(groupId)) break;
                miss = true;
            }
        }
        {
            InboundEndpoint endpoint;
            group.addEvent(event);
            if (!this.shouldAggregateEvents(group)) return result;
            MuleMessage returnMessage = this.aggregateEvents(group);
            try {
                MuleContext muleContext = MuleServer.getMuleContext();
                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(event.getEndpoint(), muleContext);
                builder.setTransformers(new LinkedList());
                builder.setName(this.getClass().getName());
                endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
            }
            catch (MuleException e) {
                throw new MessagingException(e.getI18nMessage(), returnMessage, (Throwable)e);
            }
            DefaultMuleEvent returnEvent = new DefaultMuleEvent(returnMessage, (ImmutableEndpoint)endpoint, event.getService(), event);
            result = new MuleEvent[]{returnEvent};
            this.removeEventGroup(group);
            return result;
        }
    }

    protected EventGroup createEventGroup(MuleEvent event, Object groupId) {
        return new EventGroup(groupId);
    }

    protected Object getEventGroupIdForEvent(MuleEvent event) {
        String groupId = event.getMessage().getCorrelationId();
        if (groupId == null) {
            groupId = NO_CORRELATION_ID;
        }
        return groupId;
    }

    protected EventGroup getEventGroup(Object groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = (EventGroup)this.eventGroups.putIfAbsent(group.getGroupId(), (Object)group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        this.eventGroups.remove(group.getGroupId());
    }

    protected abstract boolean shouldAggregateEvents(EventGroup var1);

    protected abstract MuleMessage aggregateEvents(EventGroup var1) throws AggregationException;
}

