/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.filters.ExceptionTypeFilter;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class ExpressionFilter
implements Filter {
    protected final transient Log logger = LogFactory.getLog(ExpressionFilter.class);
    private String evaluator;
    private String expression;
    private String customEvaluator;
    private String fullExpression;
    private boolean nullReturnsTrue = false;
    private Filter delegateFilter;

    public ExpressionFilter(String evaluator, String customEvaluator, String expression) {
        this.customEvaluator = customEvaluator;
        this.evaluator = evaluator;
        this.expression = expression;
    }

    public ExpressionFilter(String evaluator, String expression) {
        this.evaluator = evaluator;
        this.expression = expression;
    }

    public ExpressionFilter(String expression) {
        int i = expression.indexOf(":");
        if (i < 0) {
            throw new IllegalArgumentException("Expression is invalid: " + expression);
        }
        this.evaluator = expression.substring(0, i);
        this.expression = expression.substring(i + 1);
    }

    public ExpressionFilter() {
    }

    public boolean accept(MuleMessage message) {
        String expr = this.getFullExpression();
        if (this.delegateFilter != null) {
            return this.delegateFilter.accept(message);
        }
        Object result = ExpressionEvaluatorManager.evaluate(expr, message);
        if (result == null) {
            return this.nullReturnsTrue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        this.logger.warn((Object)("Expression: " + expr + ", returned an non-boolean result. Returning: " + !this.nullReturnsTrue));
        return !this.nullReturnsTrue;
    }

    protected String getFullExpression() {
        if (this.fullExpression == null) {
            if (this.evaluator == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
            }
            if (this.evaluator.equals("custom")) {
                if (this.customEvaluator == null) {
                    throw new IllegalArgumentException(CoreMessages.objectIsNull("customEvaluator").getMessage());
                }
                this.evaluator = this.customEvaluator;
            }
            if (this.evaluator.equals("header")) {
                this.delegateFilter = new MessagePropertyFilter(this.expression);
            } else if (this.evaluator.equals("regex")) {
                this.delegateFilter = new RegExFilter(this.expression);
            } else if (this.evaluator.equals("wildcard")) {
                this.delegateFilter = new WildcardFilter(this.expression);
            } else if (this.evaluator.equals("payload-type")) {
                try {
                    this.delegateFilter = new PayloadTypeFilter(this.expression);
                }
                catch (ClassNotFoundException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    throw iae;
                }
            } else if (this.evaluator.equals("exception-type")) {
                try {
                    this.delegateFilter = new ExceptionTypeFilter(this.expression);
                }
                catch (ClassNotFoundException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    throw iae;
                }
            } else {
                this.fullExpression = this.evaluator + ":" + (this.expression == null ? "" : this.expression);
            }
        }
        return this.fullExpression;
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = customEvaluator;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean isNullReturnsTrue() {
        return this.nullReturnsTrue;
    }

    public void setNullReturnsTrue(boolean nullReturnsTrue) {
        this.nullReturnsTrue = nullReturnsTrue;
    }
}

