/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.ServiceRoutingException;
import org.mule.routing.AbstractCatchAllStrategy;

public class ServiceCatchAllStrategy
extends AbstractCatchAllStrategy {
    public void setEndpoint(OutboundEndpoint endpoint) {
        throw new UnsupportedOperationException("The endpoint cannot be set on this catch all");
    }

    public OutboundEndpoint getEndpoint() {
        return null;
    }

    public synchronized MuleMessage catchMessage(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        MuleEvent event = RequestContext.getEvent();
        this.logger.debug((Object)("Catch all strategy handling event: " + event));
        try {
            this.logger.info((Object)("MuleEvent being routed from catch all strategy for endpoint: " + event.getEndpoint()));
            event = new DefaultMuleEvent(message, event.getEndpoint(), session.getService(), event);
            if (synchronous) {
                this.statistics.incrementRoutedMessage(event.getEndpoint());
                return session.getService().sendEvent(event);
            }
            this.statistics.incrementRoutedMessage(event.getEndpoint());
            session.getService().dispatchEvent(event);
            return null;
        }
        catch (MuleException e) {
            throw new ServiceRoutingException(event.getMessage(), event.getEndpoint(), session.getService(), (Throwable)e);
        }
    }
}

