/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.expression.ExpressionEvaluator;

public class MessagePayloadExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "payload";
    public static final String BYTE_ARRAY = "byte[]";
    protected final transient Log logger = LogFactory.getLog(MessagePayloadExpressionEvaluator.class);

    public Object evaluate(String expression, Object message) {
        if (message instanceof MuleMessage) {
            if (expression == null) {
                return ((MuleMessage)message).getPayload();
            }
            try {
                if (expression.equals(BYTE_ARRAY)) {
                    return ((MuleMessage)message).getPayload(byte[].class);
                }
                return ((MuleMessage)message).getPayload(ClassUtils.loadClass(expression, this.getClass()));
            }
            catch (TransformerException e) {
                throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(expression), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.warn((Object)"Message is not of type MuleMessage, the expression will return the object without modification");
            if (message instanceof MessageAdapter) {
                return ((MessageAdapter)message).getPayload();
            }
        }
        return message;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

