/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.expression.ExpressionEvaluator;
import org.mule.util.expression.ExpressionRuntimeException;

public class ExpressionEvaluatorManager {
    public static final String DEFAULT_EXPRESSION_PREFIX = "${";
    private static Map evaluator = new HashMap(8);

    public static void registerEvaluator(ExpressionEvaluator extractor) {
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("extractor").getMessage());
        }
        if (evaluator.containsKey(extractor.getName())) {
            throw new IllegalArgumentException(CoreMessages.objectAlreadyExists(extractor.getName()).getMessage());
        }
        evaluator.put(extractor.getName(), extractor);
    }

    public static boolean isEvaluatorRegistered(String name) {
        return evaluator.get(name) != null;
    }

    public static ExpressionEvaluator unregisterEvaluator(String name) {
        if (name == null) {
            return null;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)ExpressionEvaluatorManager.evaluator.remove(name);
        if (evaluator instanceof Disposable) {
            ((Disposable)((Object)evaluator)).dispose();
        }
        return evaluator;
    }

    public static Object evaluate(String expression, Object object) throws ExpressionRuntimeException {
        return ExpressionEvaluatorManager.evaluate(expression, object, DEFAULT_EXPRESSION_PREFIX, false);
    }

    public static Object evaluate(String expression, Object object, boolean failIfNull) throws ExpressionRuntimeException {
        return ExpressionEvaluatorManager.evaluate(expression, object, DEFAULT_EXPRESSION_PREFIX, failIfNull);
    }

    public static Object evaluate(String expression, Object object, String expressionPrefix, boolean failIfNull) throws ExpressionRuntimeException {
        String name;
        int i;
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith(expressionPrefix)) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            name = expression.substring(0, i);
            expression = expression.substring(i + 1);
        } else {
            name = expression;
            expression = null;
        }
        ExpressionEvaluator extractor = (ExpressionEvaluator)evaluator.get(name);
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(name).getMessage());
        }
        Object result = extractor.evaluate(expression, object);
        if (result == null && failIfNull) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(name, expression));
        }
        return result;
    }

    public static synchronized void clearEvaluators() {
        for (ExpressionEvaluator evaluator : ExpressionEvaluatorManager.evaluator.values()) {
            if (!(evaluator instanceof Disposable)) continue;
            ((Disposable)((Object)evaluator)).dispose();
        }
        evaluator.clear();
    }

    public static boolean isValidExpression(String expression) {
        return ExpressionEvaluatorManager.isValidExpression(expression, DEFAULT_EXPRESSION_PREFIX);
    }

    public static boolean isValidExpression(String expression, String expressionPrefix) {
        int i;
        if (expression.startsWith(expressionPrefix)) {
            expression = expression.substring(2, expression.length() - 1);
        }
        String name = (i = expression.indexOf(":")) > -1 ? expression.substring(0, i) : expression;
        return ExpressionEvaluatorManager.isEvaluatorRegistered(name);
    }
}

