/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.RegistryContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;

public class DefaultReplyToHandler
implements ReplyToHandler {
    protected static final Log logger = LogFactory.getLog(DefaultReplyToHandler.class);
    private volatile List transformers;
    private final Map endpointCache = new HashMap();

    public DefaultReplyToHandler(List transformers) {
        this.transformers = transformers;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
        }
        String replyToEndpoint = replyTo.toString();
        OutboundEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        returnMessage.removeProperty("MULE_REPLYTO");
        DefaultMuleEvent replyToEvent = new DefaultMuleEvent(returnMessage, (ImmutableEndpoint)endpoint, event.getSession(), false);
        try {
            endpoint.dispatch(replyToEvent);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reply to sent: " + endpoint));
            }
            event.getService().getComponent().getStatistics().incSentReplyToEvent();
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToDispatchToReplyto(endpoint), replyToEvent.getMessage(), replyToEvent.getEndpoint(), e);
        }
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleEvent event, String endpointUri) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            EndpointFactory endpointFactory = RegistryContext.getRegistry().lookupEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpointUri);
            if (this.transformers == null) {
                endpointBuilder.setTransformers(event.getEndpoint().getResponseTransformers());
            }
            endpoint = endpointFactory.getOutboundEndpoint(endpointBuilder);
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public List getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }
}

