/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.ReceiveException;
import org.mule.context.notification.MessageNotification;
import org.mule.transport.AbstractConnectable;

public abstract class AbstractMessageRequester
extends AbstractConnectable
implements MessageRequester {
    public AbstractMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    public final MuleMessage request(long timeout) throws Exception {
        try {
            this.connectionStrategy.connect(this);
            MuleMessage result = this.doRequest(timeout);
            if (result != null && this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new MessageNotification(result, this.endpoint, null, 804));
            }
            return result;
        }
        catch (DispatchException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected abstract MuleMessage doRequest(long var1) throws Exception;
}

