/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ConnectionNotification;
import org.mule.transport.AbstractConnectionStrategy;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.util.ClassUtils;

public abstract class AbstractConnectable
implements Connectable,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected WorkManager workManager = null;
    protected final ImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected boolean disposed = false;
    protected ConnectionStrategy connectionStrategy;
    protected volatile boolean connecting = false;
    protected volatile boolean connected = false;

    public AbstractConnectable(ImmutableEndpoint endpoint) {
        AbstractConnectionStrategy connStrategy;
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
        this.connectionStrategy = endpoint.getConnectionStrategy();
        if (this.connectionStrategy instanceof AbstractConnectionStrategy && (connStrategy = (AbstractConnectionStrategy)this.connectionStrategy).isDoThreading()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Overriding doThreading to false on " + connStrategy));
            }
            connStrategy.setDoThreading(false);
        }
        if (this.isDoThreading()) {
            try {
                this.workManager = this.connector.getDispatcherWorkManager();
            }
            catch (MuleException e) {
                this.disposeAndLogException();
                throw new MuleRuntimeException(CoreMessages.failedToStart("WorkManager"), (Throwable)e);
            }
        }
    }

    protected void disposeAndLogException() {
        try {
            this.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Could not dispose of the message dispatcher!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.getConnector().handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public boolean validate() {
        return !this.disposed;
    }

    public void activate() {
    }

    public void passivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.disposed) {
            try {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                this.doDispose();
                if (this.workManager != null) {
                    this.workManager.dispose();
                }
            }
            finally {
                this.disposed = true;
            }
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized void connect() throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("Requester/dispatcher has been disposed; cannot connect to resource");
        }
        if (this.connected) {
            return;
        }
        if (!this.connecting) {
            this.connecting = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting: " + this));
            }
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Connected: " + this));
            return;
        }
        try {
            this.connectionStrategy.connect(this.connector);
            this.doConnect();
            this.connected = true;
            this.connecting = false;
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 701));
        }
        catch (Exception e) {
            this.connected = false;
            this.connecting = false;
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    public synchronized void disconnect() throws Exception {
        if (!this.connected) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected = false;
        this.logger.info((Object)("Disconnected: " + this));
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(ImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI().getUri() + ")";
    }

    public final boolean isConnected() {
        return this.connected;
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    public synchronized void reconnect() throws Exception {
        this.disconnect();
        this.connect();
    }

    protected abstract void doDispose();

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI().getUri());
        sb.append(", disposed=").append(this.disposed);
        sb.append('}');
        return sb.toString();
    }
}

