/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class MessagePropertiesTransformer
extends AbstractMessageAwareTransformer {
    private List deleteProperties = null;
    private Map addProperties = null;
    private boolean overwrite = true;

    public MessagePropertiesTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new ArrayList(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap(this.addProperties));
        }
        return clone;
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            Iterator iterator = this.deleteProperties.iterator();
            while (iterator.hasNext()) {
                message.removeProperty(iterator.next().toString());
            }
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            Set propertyNames = message.getPropertyNames();
            for (Map.Entry entry : this.addProperties.entrySet()) {
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (this.overwrite) {
                    if (this.logger.isDebugEnabled() && !propertyNames.contains(key)) {
                        this.logger.debug((Object)("Overwriting message property " + key));
                    }
                    message.setProperty(key, value);
                    continue;
                }
                if (!propertyNames.contains(key) || !this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)MessageFormat.format("Message already contains the property and overwrite is false, skipping: key={0}, value={1}", key, value));
            }
        }
        return message;
    }

    public List getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(List deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public Map getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map addProperties) {
        this.addProperties = addProperties;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

