/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            if (src instanceof byte[]) {
                return SerializationUtils.deserialize((byte[])((byte[])src));
            }
            return SerializationUtils.deserialize((InputStream)((InputStream)src));
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

