/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.Base64;
import org.mule.util.IOUtils;

public class Base64Encoder
extends AbstractTransformer {
    public Base64Encoder() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            byte[] buf;
            if (src instanceof String) {
                buf = ((String)src).getBytes(encoding);
            } else if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    buf = IOUtils.toByteArray(input);
                }
                finally {
                    input.close();
                }
            } else {
                buf = (byte[])src;
            }
            String result = Base64.encodeBytes(buf, 8);
            if (this.getReturnClass().equals(byte[].class)) {
                return result.getBytes(encoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "base64"), this, (Throwable)ex);
        }
    }
}

