/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public abstract class AbstractTransformer
implements Transformer {
    protected static final int DEFAULT_TRUNCATE_LENGTH = 200;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class returnClass = Object.class;
    protected String name = null;
    protected ImmutableEndpoint endpoint = null;
    protected final List sourceTypes = new CopyOnWriteArrayList();
    private boolean ignoreBadInput = false;

    protected Object checkReturnClass(Object object) throws TransformerException {
        if (this.returnClass != null && !this.returnClass.isInstance(object)) {
            throw new TransformerException(CoreMessages.transformUnexpectedType(object.getClass(), this.returnClass), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The transformed object is of expected type. Type is: " + ClassUtils.getSimpleName(object.getClass())));
        }
        return object;
    }

    protected void registerSourceType(Class aClass) {
        if (!this.sourceTypes.contains(aClass)) {
            this.sourceTypes.add(aClass);
            if (aClass.equals(Object.class)) {
                this.logger.debug((Object)"java.lang.Object has been added as source type for this transformer, there will be no source type checking performed");
            }
        }
    }

    protected void unregisterSourceType(Class aClass) {
        this.sourceTypes.remove(aClass);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.generateTransformerName();
        }
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            string = ClassUtils.getSimpleName(this.getClass());
        }
        this.logger.debug((Object)("Setting transformer name to: " + string));
        this.name = string;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class newClass) {
        this.returnClass = newClass;
    }

    public boolean isSourceTypeSupported(Class aClass) {
        return this.isSourceTypeSupported(aClass, false);
    }

    public boolean isSourceTypeSupported(Class aClass, boolean exactMatch) {
        int numTypes = this.sourceTypes.size();
        if (numTypes == 0) {
            return !exactMatch;
        }
        for (int i = 0; i < numTypes; ++i) {
            Class anotherClass = (Class)this.sourceTypes.get(i);
            if (!(exactMatch ? anotherClass.equals(aClass) : anotherClass.isAssignableFrom(aClass))) continue;
            return true;
        }
        return false;
    }

    public final Object transform(Object src) throws TransformerException {
        Object result;
        String encoding = null;
        Object payload = src;
        if (src instanceof MessageAdapter) {
            encoding = ((MessageAdapter)src).getEncoding();
            MessageAdapter adapter = (MessageAdapter)src;
            if (!(this.isSourceTypeSupported(MessageAdapter.class, true) || this.isSourceTypeSupported(MuleMessage.class, true) || this instanceof AbstractMessageAwareTransformer)) {
                src = ((MessageAdapter)src).getPayload();
                payload = adapter.getPayload();
            }
        }
        if (encoding == null && this.endpoint != null) {
            encoding = this.endpoint.getEncoding();
        } else if (encoding == null) {
            encoding = "UTF-8";
        }
        Class<?> srcCls = src.getClass();
        if (!this.isSourceTypeSupported(srcCls)) {
            if (this.ignoreBadInput) {
                this.logger.debug((Object)"Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return payload;
            }
            throw new TransformerException(CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), payload.getClass(), this.endpoint), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying transformer " + this.getName() + " (" + this.getClass().getName() + ")"));
            this.logger.debug((Object)("Object before transform: " + StringMessageUtils.truncate(StringMessageUtils.toString(payload), 200, false)));
        }
        if ((result = this.doTransform(payload, encoding)) == null) {
            result = NullPayload.getInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Object after transform: " + StringMessageUtils.truncate(StringMessageUtils.toString(result), 200, false)));
        }
        result = this.checkReturnClass(result);
        return result;
    }

    protected boolean isConsumed(Class srcCls) {
        return InputStream.class.isAssignableFrom(srcCls) || StreamSource.class.isAssignableFrom(srcCls);
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected abstract Object doTransform(Object var1, String var2) throws TransformerException;

    public LifecycleTransitionResult initialise() throws InitialisationException {
        return LifecycleTransitionResult.OK;
    }

    protected String generateTransformerName() {
        String name = ClassUtils.getSimpleName(this.getClass());
        int i = name.indexOf("To");
        if (i > 0 && this.returnClass != null) {
            String target = ClassUtils.getSimpleName(this.returnClass);
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            name = name.substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return name;
    }

    public List getSourceTypes() {
        return Collections.unmodifiableList(this.sourceTypes);
    }

    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", ignoreBadInput=").append(this.ignoreBadInput);
        sb.append(", returnClass=").append(this.returnClass);
        sb.append(", sourceTypes=").append(this.sourceTypes);
        sb.append('}');
        return sb.toString();
    }

    public boolean isAcceptNull() {
        return false;
    }
}

