/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.AbstractJCEEncryptionStrategy;

public class PasswordBasedEncryptionStrategy
extends AbstractJCEEncryptionStrategy {
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    public static final int DEFAULT_ITERATION_COUNT = 20;
    private byte[] salt = null;
    private int iterationCount = 20;
    private char[] password;

    public PasswordBasedEncryptionStrategy() {
        this.algorithm = DEFAULT_ALGORITHM;
    }

    public LifecycleTransitionResult initialise() throws InitialisationException {
        if (this.salt == null) {
            this.salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
            this.logger.debug((Object)"Salt is not set. Using default salt");
        }
        if (this.password == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Password"), (Initialisable)this);
        }
        return super.initialise();
    }

    protected KeySpec createKeySpec() {
        return new PBEKeySpec(this.password);
    }

    protected AlgorithmParameterSpec createAlgorithmParameterSpec() {
        return new PBEParameterSpec(this.salt, this.iterationCount);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    protected SecretKey getSecretKey() throws GeneralSecurityException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.getAlgorithm());
        return keyFactory.generateSecret(this.keySpec);
    }
}

