/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.routing.ResponseRouter;
import org.mule.routing.AbstractRouter;
import org.mule.routing.CorrelationPropertiesExpressionEvaluator;
import org.mule.util.ClassUtils;
import org.mule.util.expression.ExpressionEvaluator;

public abstract class AbstractResponseRouter
extends AbstractRouter
implements ResponseRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int timeout = -1;
    private boolean failOnTimeout = true;
    protected ExpressionEvaluator propertyExtractor = new CorrelationPropertiesExpressionEvaluator();

    public LifecycleTransitionResult initialise() throws InitialisationException {
        if (this.timeout == -1) {
            this.setTimeout(this.muleContext.getConfiguration().getDefaultSynchronousEventTimeout());
        }
        return super.initialise();
    }

    public ExpressionEvaluator getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(ExpressionEvaluator propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public void setPropertyExtractorAsString(String className) {
        try {
            this.propertyExtractor = (ExpressionEvaluator)ClassUtils.instanciateClass(className, null, this.getClass());
        }
        catch (Exception ex) {
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't instanciate property extractor class " + className).initCause(ex);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Object getReplyAggregateIdentifier(MuleMessage message) {
        return this.propertyExtractor.evaluate("MULE_CORRELATION_ID", message);
    }

    protected Object getCallResponseAggregateIdentifier(MuleMessage message) {
        return this.propertyExtractor.evaluate("MULE_MESSAGE_ID", message);
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }
}

