/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.util.MapUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected final ConcurrentMap eventGroups = new ConcurrentHashMap();
    protected final ConcurrentMap locks = new ConcurrentHashMap();
    protected final ConcurrentMap responseMessages = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(MuleEvent event) throws RoutingException {
        EventGroup group;
        Object groupId = this.getReplyAggregateIdentifier(event.getMessage());
        if (groupId == null) throw new RoutingException(CoreMessages.noCorrelationId(), event.getMessage(), event.getEndpoint());
        if (groupId.equals("-1")) {
            throw new RoutingException(CoreMessages.noCorrelationId(), event.getMessage(), event.getEndpoint());
        }
        boolean lookupMiss = false;
        while (true) {
            if (lookupMiss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((group = this.getEventGroup(groupId)) == null) {
                group = this.addEventGroup(this.createEventGroup(event, groupId));
            }
            EventGroup eventGroup = group;
            synchronized (eventGroup) {
                if (group == this.getEventGroup(groupId)) break;
                lookupMiss = true;
            }
        }
        {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding event to response aggregator group: " + groupId));
            }
            group.addEvent(event);
            if (!this.shouldAggregateEvents(group)) return;
            MuleMessage returnMessage = this.aggregateEvents(group);
            this.removeEventGroup(group);
            MuleMessage previousResult = (MuleMessage)this.responseMessages.putIfAbsent(groupId, (Object)returnMessage);
            if (previousResult != null) {
                throw new IllegalStateException("Detected duplicate aggregation result message with id: " + groupId);
            }
            Latch l = (Latch)((Object)this.locks.get(groupId));
            if (l == null) {
                Latch previous;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating latch for " + groupId + " in " + this));
                }
                if ((previous = (Latch)((Object)this.locks.putIfAbsent(groupId, (Object)(l = new Latch())))) != null) {
                    l = previous;
                }
            }
            l.countDown();
            return;
        }
    }

    protected EventGroup createEventGroup(MuleEvent event, Object groupId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new event group: " + groupId + " in " + this));
        }
        return new EventGroup(groupId);
    }

    protected EventGroup getEventGroup(Object groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = (EventGroup)this.eventGroups.putIfAbsent(group.getGroupId(), (Object)group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        this.eventGroups.remove(group.getGroupId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessage getResponse(MuleMessage message) throws RoutingException {
        MuleMessage result;
        Latch l;
        Object responseId = this.getCallResponseAggregateIdentifier(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for response for message id: " + responseId + " in " + this));
        }
        if ((l = (Latch)((Object)this.locks.get(responseId))) == null) {
            Latch previous;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got response but no one is waiting for it yet. Creating latch for " + responseId + " in " + this));
            }
            if ((previous = (Latch)((Object)this.locks.putIfAbsent(responseId, (Object)(l = new Latch())))) != null) {
                l = previous;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Got latch for message: " + responseId));
        }
        boolean resultAvailable = false;
        boolean interruptedWhileWaiting = false;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Waiting for response to message: " + responseId));
            }
            if (this.getTimeout() <= 0) {
                l.await();
                resultAvailable = true;
            } else {
                resultAvailable = l.await(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            interruptedWhileWaiting = true;
        }
        finally {
            this.locks.remove(responseId);
            result = (MuleMessage)this.responseMessages.remove(responseId);
            if (interruptedWhileWaiting) {
                Thread.currentThread().interrupt();
            }
        }
        if (!resultAvailable) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Current responses are: \n" + MapUtils.toString((Map)this.responseMessages, true)));
            }
            throw new ResponseTimeoutException(CoreMessages.responseTimedOutWaitingForId(this.getTimeout(), responseId), message, null);
        }
        if (result == null) {
            throw new IllegalStateException("Response Message is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("remaining locks  : " + this.locks.keySet()));
            this.logger.debug((Object)("remaining results: " + this.responseMessages.keySet()));
        }
        return result;
    }

    protected abstract boolean shouldAggregateEvents(EventGroup var1);

    protected abstract MuleMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

