/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.util.StringUtils;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class EndpointSelector
extends FilteringOutboundRouter
implements MuleContextAware {
    public static final String DEFAULT_SELECTOR_PROPERTY = "endpoint";
    public static final String DEFAULT_SELECTOR_EXPRESSION = "header:endpoint";
    private String selectorExpression = "header:endpoint";

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        List endpoints;
        String prop = this.getSelectorExpression();
        if (!ExpressionEvaluatorManager.isValidExpression(prop)) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionInvalidForProperty("selectorExpression", prop), message, null);
        }
        Object property = ExpressionEvaluatorManager.evaluate(prop, message);
        if (property == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSetOnEvent(this.getSelectorExpression()), message, null);
        }
        if (property instanceof String) {
            endpoints = new ArrayList<Object>(1);
            endpoints.add(property);
        } else if (property instanceof List) {
            endpoints = (List)property;
        } else {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.getSelectorExpression(), new Class[]{String.class, List.class}, property.getClass()), message, null);
        }
        MuleMessage result = null;
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            String endpointName = iterator.next().toString();
            if (StringUtils.isEmpty((String)endpointName)) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.objectIsNull("Endpoint Name: " + this.getSelectorExpression()), message, null);
            }
            OutboundEndpoint ep = null;
            try {
                ep = this.lookupEndpoint(endpointName);
                if (ep == null) {
                    throw new CouldNotRouteOutboundMessageException(CoreMessages.objectNotFound("Endpoint", endpointName), message, ep);
                }
                if (synchronous) {
                    result = this.send(session, message, ep);
                    continue;
                }
                this.dispatch(session, message, ep);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
            }
        }
        return result;
    }

    protected OutboundEndpoint lookupEndpoint(String endpointName) throws MuleException {
        for (OutboundEndpoint ep : this.endpoints) {
            if (endpointName.equals(ep.getEndpointURI().getEndpointName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        return this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName);
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public void setSelectorExpression(String selectorExpression) {
        this.selectorExpression = selectorExpression;
    }
}

