/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractMessageSplitter
extends FilteringOutboundRouter {
    protected boolean multimatch = true;
    protected boolean honorSynchronicity = false;

    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        String correlationId = (String)this.propertyExtractor.evaluate("MULE_CORRELATION_ID", message);
        this.initialise(message);
        MuleMessage result = null;
        List list = this.getEndpoints();
        int correlationSequence = 1;
        block2: for (OutboundEndpoint endpoint : list) {
            if ((message = this.getMessagePart(message, endpoint)) == null) {
                this.logger.warn((Object)("Message part is null for endpoint: " + endpoint.getEndpointURI().toString()));
            }
            while (message != null) {
                if (this.honorSynchronicity) {
                    synchronous = endpoint.isSynchronous();
                }
                try {
                    if (this.enableCorrelation != 2) {
                        boolean correlationSet;
                        boolean bl = correlationSet = message.getCorrelationId() != null;
                        if (!correlationSet && this.enableCorrelation == 0) {
                            message.setCorrelationId(correlationId);
                        }
                        int groupSize = message.getCorrelationGroupSize();
                        message.setCorrelationGroupSize(groupSize);
                        message.setCorrelationSequence(correlationSequence++);
                    }
                    if (this.honorSynchronicity) {
                        message.setBooleanProperty("MULE_REMOTE_SYNC", endpoint.isRemoteSync());
                    }
                    if (synchronous) {
                        result = this.send(session, message, endpoint);
                    } else {
                        this.dispatch(session, message, endpoint);
                    }
                }
                catch (MuleException e) {
                    throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
                }
                if (!this.multimatch) continue block2;
                message = this.getMessagePart(message, endpoint);
            }
        }
        this.cleanup();
        return result;
    }

    public boolean isHonorSynchronicity() {
        return this.honorSynchronicity;
    }

    public void setHonorSynchronicity(boolean honorSynchronicity) {
        this.honorSynchronicity = honorSynchronicity;
    }

    protected abstract void initialise(MuleMessage var1);

    protected abstract MuleMessage getMessagePart(MuleMessage var1, OutboundEndpoint var2);

    protected abstract void cleanup();
}

