/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.model.Model;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.service.Service;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerCollection;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.ObjectToString;
import org.mule.util.CollectionUtils;
import org.mule.util.UUID;
import org.mule.util.expression.ExpressionEvaluatorManager;

public abstract class AbstractRegistry
implements Registry {
    private static final ObjectToString objectToString = new ObjectToString();
    private static final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private Registry parent;
    private String id;
    private int defaultScope = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected LifecycleManager lifecycleManager;
    protected Map transformerListCache = new ConcurrentHashMap(8);
    protected Map exactTransformerCache = new ConcurrentHashMap(8);

    protected AbstractRegistry(String id) {
        if (id == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("RegistryID").getMessage());
        }
        this.id = id;
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected AbstractRegistry(String id, Registry parent) {
        this(id);
        this.setParent(parent);
    }

    protected abstract LifecycleManager createLifecycleManager();

    protected LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public final synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.exactTransformerCache.clear();
            this.transformerListCache.clear();
            this.doDispose();
            this.lifecycleManager.firePhase(MuleServer.getMuleContext(), "dispose");
            if (this.getParent() != null) {
                this.parent.dispose();
            } else {
                RegistryContext.setRegistry(null);
                ExpressionEvaluatorManager.clearEvaluators();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to cleanly dispose: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "initialise".equals(this.lifecycleManager.getExecutingPhase());
    }

    public final LifecycleTransitionResult initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.id == null) {
            this.logger.warn((Object)"No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
            this.lifecycleManager.firePhase(MuleServer.getMuleContext(), "initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        return LifecycleTransitionResult.OK;
    }

    protected void doInitialise() throws InitialisationException {
    }

    public Connector lookupConnector(String name) {
        return (Connector)this.lookupObject(name);
    }

    public ImmutableEndpoint lookupEndpoint(String name) {
        Object obj = this.lookupObject(name);
        if (obj instanceof ImmutableEndpoint) {
            return (ImmutableEndpoint)obj;
        }
        this.logger.debug((Object)("No endpoint with the name: " + name + "found.  If " + name + " is a global endpoint you should use the EndpointFactory to create endpoint instances from global endpoints."));
        return null;
    }

    public EndpointBuilder lookupEndpointBuilder(String name) {
        Object o = this.lookupObject(name);
        if (o instanceof EndpointBuilder) {
            this.logger.debug((Object)("Global endpoint EndpointBuilder for name: " + name + " found"));
            return (EndpointBuilder)o;
        }
        this.logger.debug((Object)("No endpoint builder with the name: " + name + " found."));
        return null;
    }

    public EndpointFactory lookupEndpointFactory() {
        return (EndpointFactory)this.lookupObject("_muleEndpointFactory");
    }

    public Transformer lookupTransformer(String name) {
        return (Transformer)this.lookupObject(name);
    }

    public Transformer lookupTransformer(Class inputType, Class outputType) throws TransformerException {
        Transformer result = (Transformer)this.exactTransformerCache.get(inputType.getName() + outputType.getName());
        if (result != null) {
            return result;
        }
        List trans = this.lookupTransformers(inputType, outputType);
        result = this.getNearestTransformerMatch(trans, inputType, outputType);
        AbstractTransformer secondPass = null;
        if (result == null) {
            if (outputType.equals(String.class)) {
                secondPass = objectToString;
            } else if (outputType.equals(byte[].class)) {
                secondPass = objectToByteArray;
            } else {
                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(inputType, outputType));
            }
            trans = this.lookupTransformers(inputType, Object.class);
            result = this.getNearestTransformerMatch(trans, inputType, outputType);
            if (result != null) {
                result = new TransformerCollection(new Transformer[]{result, secondPass});
            }
        }
        if (result != null) {
            this.exactTransformerCache.put(inputType.getName() + outputType.getName(), result);
        }
        return result;
    }

    protected Transformer getNearestTransformerMatch(List trans, Class input, Class output) throws TransformerException {
        if (trans.size() > 1) {
            TransformerWeighting weighting = null;
            for (Transformer transformer : trans) {
                TransformerWeighting current = new TransformerWeighting(input, output, transformer);
                if (weighting == null) {
                    weighting = current;
                    continue;
                }
                int compare = current.compareTo(weighting);
                if (compare == 1) {
                    weighting = current;
                    continue;
                }
                if (compare != 0 || weighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                throw new TransformerException(CoreMessages.transformHasMultipleMatches(input, output, current.getTransformer(), weighting.getTransformer()));
            }
            return weighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return (Transformer)trans.get(0);
    }

    public List lookupTransformers(Class input, Class output) {
        ArrayList<Transformer> results = (ArrayList<Transformer>)this.transformerListCache.get(input.getName() + output.getName());
        if (results != null) {
            return results;
        }
        results = new ArrayList<Transformer>(2);
        Collection transformers = this.getTransformers();
        for (Transformer t : transformers) {
            if (!(t instanceof DiscoverableTransformer)) continue;
            Class<Object> c = t.getReturnClass();
            if (c == null) {
                c = Object.class;
            }
            if (!output.isAssignableFrom(c) || !t.isSourceTypeSupported(input)) continue;
            results.add(t);
        }
        this.transformerListCache.put(input.getName() + output.getName(), results);
        return results;
    }

    public Model lookupModel(String name) {
        return (Model)this.lookupObject(name);
    }

    public Model lookupSystemModel() {
        return this.lookupModel("_muleSystemModel");
    }

    public Collection getModels() {
        return this.lookupObjects(Model.class);
    }

    public Collection getConnectors() {
        return this.lookupObjects(Connector.class);
    }

    public Collection getAgents() {
        return this.lookupObjects(Agent.class);
    }

    public Collection getEndpoints() {
        return this.lookupObjects(ImmutableEndpoint.class);
    }

    public Collection getTransformers() {
        return this.lookupObjects(Transformer.class);
    }

    public Agent lookupAgent(String name) {
        return (Agent)this.lookupObject(name);
    }

    public Service lookupService(String name) {
        return (Service)this.lookupObject(name);
    }

    public Collection lookupServices() {
        return this.lookupObjects(Service.class);
    }

    public Collection lookupServices(String model) {
        Collection components = this.lookupServices();
        ArrayList<Service> modelComponents = new ArrayList<Service>();
        for (Service service : components) {
            if (!model.equals(service.getModel().getName())) continue;
            modelComponents.add(service);
        }
        return modelComponents;
    }

    public final Object lookupObject(String key, int scope) {
        this.logger.debug((Object)("lookupObject: key=" + key + " scope=" + scope));
        Object o = this.doLookupObject(key);
        if (o == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to find object in Registry ID: " + this.getRegistryId()));
            }
            if (this.getParent() != null && scope > 0) {
                if (this.getParent().isRemote() && scope == 2) {
                    o = this.getParent().lookupObject(key);
                } else if (!this.getParent().isRemote() && scope >= 1) {
                    o = this.getParent().lookupObject(key);
                }
            }
        }
        return o;
    }

    public final Object lookupObject(Class type) throws RegistrationException {
        return this.lookupObject(type, this.getDefaultScope());
    }

    public final Object lookupObject(Class type, int scope) throws RegistrationException {
        Collection collection = this.lookupObjects(type, scope);
        if (collection == null || collection.size() < 1) {
            return null;
        }
        if (collection.size() > 1) {
            throw new RegistrationException("More than one object of type " + type + " was found in registry, but only 1 was expected.");
        }
        return collection.iterator().next();
    }

    public final Collection lookupObjects(Class type) {
        return this.lookupObjects(type, this.getDefaultScope());
    }

    public final Collection lookupObjects(Class type, int scope) {
        this.logger.debug((Object)("lookupObjects: type=" + type + " scope=" + scope));
        Collection collection = this.doLookupObjects(type);
        if (collection == null) {
            collection = new ArrayList();
        }
        if (this.getParent() != null && scope > 0) {
            Collection collection2;
            if (this.getParent().isRemote() && scope == 2) {
                Collection collection22 = this.getParent().lookupObjects(type);
                if (collection22 != null) {
                    collection.addAll(collection22);
                }
            } else if (!this.getParent().isRemote() && scope >= 1 && (collection2 = this.getParent().lookupObjects(type)) != null) {
                collection = CollectionUtils.union(collection, (Collection)collection2);
            }
        }
        return collection;
    }

    protected abstract Collection doLookupObjects(Class var1);

    public Object lookupObject(String key) {
        return this.lookupObject(key, this.getDefaultScope());
    }

    protected abstract Object doLookupObject(String var1);

    protected void unsupportedOperation(String operation, Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Registry: " + this.getRegistryId() + " is read-only so objects cannot be registered or unregistered. Failed to execute operation " + operation + " on object: " + o);
    }

    public final void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    public final void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.logger.debug((Object)("registerObject: key=" + key + " value=" + value + " metadata=" + metadata));
        if (value instanceof MuleContextAware) {
            ((MuleContextAware)value).setMuleContext(MuleServer.getMuleContext());
        }
        this.doRegisterObject(key, value, metadata);
    }

    protected abstract void doRegisterObject(String var1, Object var2, Object var3) throws RegistrationException;

    public final void registerTransformer(Transformer transformer) throws MuleException {
        if (transformer instanceof DiscoverableTransformer) {
            this.exactTransformerCache.clear();
            this.transformerListCache.clear();
        }
        this.doRegisterTransformer(transformer);
    }

    protected abstract void doRegisterTransformer(Transformer var1) throws MuleException;

    public final String getRegistryId() {
        return this.id;
    }

    public Registry getParent() {
        return this.parent;
    }

    public void setParent(Registry registry) {
        this.parent = registry;
    }

    public int getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(int scope) {
        if (scope < 0 || scope > 2) {
            throw new IllegalArgumentException("Invalid value for scope: " + scope);
        }
        this.defaultScope = scope;
    }
}

