/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda;

import java.util.NoSuchElementException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.DefaultMuleEvent;
import org.mule.FailedToQueueEventException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.ServiceException;
import org.mule.component.AbstractComponent;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.management.stats.ServiceStatistics;
import org.mule.model.seda.SedaModel;
import org.mule.service.AbstractService;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class SedaService
extends AbstractService
implements Work,
WorkListener {
    private static final long serialVersionUID = 7711976708670893015L;
    protected WorkManager workManager;
    protected Integer queueTimeout;
    protected ThreadingProfile threadingProfile;
    protected QueueProfile queueProfile;
    protected Queue queue;

    protected synchronized void doInitialise() throws InitialisationException {
        MuleConfiguration config = this.muleContext.getConfiguration();
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultComponentThreadingProfile();
        }
        this.workManager = this.threadingProfile.createWorkManager(this.getName());
        if (this.queueProfile == null) {
            this.queueProfile = ((SedaModel)this.model).getQueueProfile();
        }
        if (this.queueTimeout == null) {
            this.setQueueTimeout(new Integer(((SedaModel)this.model).getQueueTimeout()));
        }
        try {
            if (this.name == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Service has no name to identify it"), (Initialisable)this);
            }
            this.queueProfile.configureQueue(this.name, this.muleContext.getQueueManager());
            this.queue = this.muleContext.getQueueManager().getQueueSession().getQueue(this.name);
            if (this.queue == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for service " + this.name), (Initialisable)this);
            }
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Service Queue"), e, this);
        }
    }

    protected void doForceStop() throws MuleException {
        this.doStop();
    }

    protected void doStop() throws MuleException {
        if (this.muleContext.getQueueManager().getQueueSession().getQueue(this.name).size() > 0) {
            try {
                this.stopping.whenFalse(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.workManager.dispose();
    }

    protected void doStart() throws MuleException {
        try {
            this.workManager.start();
            this.workManager.scheduleWork(this, Long.MAX_VALUE, null, this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Service: " + this.name), e, this);
        }
    }

    protected void doDispose() {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    protected void doDispatch(MuleEvent event) throws MuleException {
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.name + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        try {
            this.enqueue(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (Exception e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException(CoreMessages.interruptedQueuingEventFor(this.getName()), event.getMessage(), this, e);
            this.handleException(e1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MuleEvent added to queue for: " + this.name));
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws MuleException {
        MuleMessage result = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + this.component));
            }
            result = this.component.onCall(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(event.getMessage(), this, (Throwable)e);
        }
        return result;
    }

    public int getQueueSize() {
        QueueSession session = this.muleContext.getQueueManager().getQueueSession();
        Queue queue = session.getQueue(this.name);
        if (queue == null) {
            this.logger.warn((Object)new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for service " + this.name), (Initialisable)this));
            return -1;
        }
        return queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DefaultMuleEvent event = null;
        QueueSession queueSession = this.muleContext.getQueueManager().getQueueSession();
        while (!this.stopped.get()) {
            try {
                this.paused.whenFalse(null);
                if (this.stopping.get() && (queueSession == null || this.getQueueSize() <= 0)) {
                    this.stopping.set(false);
                    break;
                }
                event = (DefaultMuleEvent)this.dequeue();
                if (event == null) continue;
                if (this.stats.isEnabled()) {
                    this.stats.decQueuedEvent();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Service: " + this.name + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
                }
                this.workManager.scheduleWork(new ComponentStageWorker(event), Long.MAX_VALUE, null, this);
            }
            catch (Exception e) {
                if (this.isStopped() || this.isStopping()) break;
                if (e instanceof InterruptedException) {
                    this.stopping.set(false);
                    break;
                }
                if (e instanceof NoSuchElementException) {
                    this.handleException(new ServiceException(CoreMessages.proxyPoolTimedOut(), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                if (e instanceof MuleException) {
                    this.handleException(e);
                    continue;
                }
                if (e instanceof WorkException) {
                    this.handleException(new ServiceException(CoreMessages.eventProcessingFailedFor(this.name), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                this.handleException(new ServiceException(CoreMessages.failedToGetPooledObject(), event == null ? null : event.getMessage(), this, e));
            }
            finally {
                this.stopping.set(false);
            }
        }
    }

    public void release() {
        this.stopping.set(false);
    }

    protected void enqueue(MuleEvent event) throws Exception {
        QueueSession session = this.muleContext.getQueueManager().getQueueSession();
        Queue queue = session.getQueue(this.name);
        if (queue == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for service " + this.name), (Initialisable)this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service " + this.name + " putting event on queue " + this.name + ": " + event));
        }
        queue.put(event);
    }

    protected MuleEvent dequeue() throws Exception {
        if (this.logger.isDebugEnabled()) {
            // empty if block
        }
        if (this.getQueueTimeout() == null) {
            throw new InitialisationException(CoreMessages.noServiceQueueTimeoutSet(this), (Initialisable)this);
        }
        return (MuleEvent)this.queue.poll(this.getQueueTimeout().intValue());
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null || event.getException() == null) {
            return;
        }
        Throwable e = event.getException();
        if (event.getException().getCause() != null) {
            e = event.getException().getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.componentCausedErrorIs(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.getName(), this.threadingProfile.getMaxThreadsActive());
    }

    public Object getInstance() throws MuleException {
        throw new UnsupportedOperationException("Direct access to underlying service object is not allowed in the SedaModel.  If this is for a unit test, make sure you are using the TestSedaModel ('seda-test')");
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    private class ComponentStageWorker
    implements Work {
        private MuleEvent event;

        public ComponentStageWorker(MuleEvent event) {
            this.event = event;
        }

        public void run() {
            ((AbstractComponent)SedaService.this.component).onEvent(this.event);
        }

        public void release() {
        }
    }
}

