/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.pipeline;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.transport.DispatchException;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.direct.DirectService;

public class PipelineService
extends DirectService {
    private static final long serialVersionUID = -2788210157354765190L;

    protected MuleMessage doSend(MuleEvent event) throws MuleException {
        try {
            MuleMessage result = this.component.onCall(event);
            MuleMessage returnMessage = null;
            returnMessage = result instanceof MuleMessage ? result : new DefaultMuleMessage((Object)result, event.getMessage());
            if (!event.isStopFurtherProcessing()) {
                if (this.outboundRouter.hasEndpoints()) {
                    MuleMessage outboundReturnMessage = this.outboundRouter.route(returnMessage, event.getSession(), event.isSynchronous());
                    if (outboundReturnMessage != null) {
                        returnMessage = outboundReturnMessage;
                    }
                } else {
                    this.logger.debug((Object)("Outbound router on service '" + this.name + "' doesn't have any endpoints configured."));
                }
            }
            return returnMessage;
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void doDispatch(MuleEvent event) throws MuleException {
        this.sendEvent(event);
    }

    public void setComponent(Component component) {
        if (!(component instanceof SimpleCallableJavaComponent)) {
            throw new MuleRuntimeException(CoreMessages.objectNotOfCorrectType(component.getClass(), SimpleCallableJavaComponent.class));
        }
        super.setComponent(component);
    }
}

