/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.LifecycleObject;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public class DefaultLifecyclePhase
implements LifecyclePhase {
    protected final transient Log logger = LogFactory.getLog(DefaultLifecyclePhase.class);
    public static final int RETRY_MAX = 3;
    private Class lifecycleClass;
    private Method lifecycleMethod;
    private Set orderedLifecycleObjects = new LinkedHashSet(6);
    private Class[] ignorredObjectTypes;
    private String name;
    private String oppositeLifecyclePhase;
    private Set supportedPhases;
    private int registryScope = 2;

    public DefaultLifecyclePhase(String name, Class lifecycleClass, String oppositeLifecyclePhase) {
        this.name = name;
        this.lifecycleClass = lifecycleClass;
        this.lifecycleMethod = lifecycleClass.getMethods()[0];
        this.oppositeLifecyclePhase = oppositeLifecyclePhase;
    }

    public void fireLifecycle(MuleContext muleContext, String currentPhase) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to fire lifecycle phase: " + this.getName()));
        }
        if (currentPhase.equals(this.name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not firing, already in lifecycle phase: " + this.getName()));
            }
            return;
        }
        if (!this.isPhaseSupported(currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + this.name + " does not support current phase: " + currentPhase + ". Phases supported are: " + StringMessageUtils.toString(this.supportedPhases));
        }
        HashSet duplicates = new HashSet();
        for (LifecycleObject lo : this.orderedLifecycleObjects) {
            LinkedList targets = new LinkedList(RegistryContext.getRegistry().lookupObjects(lo.getType(), this.getRegistryScope()));
            if (targets.size() <= 0) continue;
            lo.firePreNotification(muleContext);
            for (int retryCount = 0; retryCount < 3 && targets.size() > 0; ++retryCount) {
                Iterator target = targets.iterator();
                while (target.hasNext()) {
                    LifecycleTransitionResult result;
                    Object o = target.next();
                    if (duplicates.contains(o)) {
                        target.remove();
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("lifecycle phase: " + this.getName() + " for object: " + o));
                    }
                    if ((result = this.applyLifecycle(o)).isOk()) {
                        target.remove();
                        duplicates.add(o);
                        continue;
                    }
                    if (retryCount + 1 == 3) {
                        throw (LifecycleException)new LifecycleException(CoreMessages.exceededRetry(this.getName(), o), o).initCause(result.getThrowable());
                    }
                    this.logger.debug((Object)("Retry requested for " + o));
                }
            }
            lo.firePostNotification(muleContext);
        }
    }

    public void addOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.add(lco);
    }

    public void removeOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.remove(lco);
    }

    protected boolean ignoreType(Class type) {
        if (this.ignorredObjectTypes == null) {
            return false;
        }
        for (int i = 0; i < this.ignorredObjectTypes.length; ++i) {
            Class ignorredObjectType = this.ignorredObjectTypes[i];
            if (!ignorredObjectType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public Set getOrderedLifecycleObjects() {
        return this.orderedLifecycleObjects;
    }

    public void setOrderedLifecycleObjects(Set orderedLifecycleObjects) {
        this.orderedLifecycleObjects = orderedLifecycleObjects;
    }

    public Class[] getIgnoredObjectTypes() {
        return this.ignorredObjectTypes;
    }

    public void setIgnoredObjectTypes(Class[] ignorredObjectTypes) {
        this.ignorredObjectTypes = ignorredObjectTypes;
    }

    public Class getLifecycleClass() {
        return this.lifecycleClass;
    }

    public void setLifecycleClass(Class lifecycleClass) {
        this.lifecycleClass = lifecycleClass;
    }

    public String getName() {
        return this.name;
    }

    public Set getSupportedPhases() {
        return this.supportedPhases;
    }

    public void setSupportedPhases(Set supportedPhases) {
        this.supportedPhases = supportedPhases;
    }

    public void registerSupportedPhase(String phase) {
        if (this.supportedPhases == null) {
            this.supportedPhases = new HashSet();
        }
        this.supportedPhases.add(phase);
    }

    public boolean isPhaseSupported(String phase) {
        if (this.getSupportedPhases() == null) {
            return true;
        }
        if (this.getSupportedPhases().contains("all")) {
            return true;
        }
        return this.getSupportedPhases().contains(phase);
    }

    public LifecycleTransitionResult applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return LifecycleTransitionResult.OK;
        }
        if (this.ignoreType(o.getClass())) {
            return LifecycleTransitionResult.OK;
        }
        if (!this.getLifecycleClass().isAssignableFrom(o.getClass())) {
            return LifecycleTransitionResult.OK;
        }
        try {
            Object result = this.lifecycleMethod.invoke(o, ClassUtils.NO_ARGS);
            if (null == result) {
                return LifecycleTransitionResult.OK;
            }
            return (LifecycleTransitionResult)result;
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(this.lifecycleMethod.getName(), o), e, this);
        }
    }

    public int getRegistryScope() {
        return this.registryScope;
    }

    public void setRegistryScope(int registryScope) {
        this.registryScope = registryScope;
    }

    public String getOppositeLifecyclePhase() {
        return this.oppositeLifecyclePhase;
    }
}

