/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.registry.ServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class MuleEndpointURI
implements EndpointURI {
    private static final long serialVersionUID = 3906735768171252877L;
    protected static final Log logger = LogFactory.getLog(MuleEndpointURI.class);
    private String address;
    private String filterAddress;
    private String endpointName;
    private String connectorName;
    private String transformers;
    private String responseTransformers;
    private Properties params = new Properties();
    private URI uri;
    private String userInfo;
    private String schemeMetaInfo;
    private String resourceInfo;

    public static boolean isMuleUri(String url) {
        return url.indexOf(":/") != -1;
    }

    MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri, String userInfo) {
        this(address, endpointName, connectorName, transformers, responseTransformers, properties, uri);
        if (userInfo != null) {
            this.userInfo = userInfo;
        }
    }

    public MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri) {
        this.address = address;
        this.endpointName = endpointName;
        this.connectorName = connectorName;
        this.transformers = transformers;
        this.responseTransformers = responseTransformers;
        this.params = properties;
        this.uri = uri;
        this.userInfo = uri.getUserInfo();
        if (properties != null) {
            this.resourceInfo = (String)properties.remove("resourceInfo");
        }
    }

    public MuleEndpointURI(EndpointURI endpointUri) {
        this.initialise(endpointUri);
    }

    public MuleEndpointURI(EndpointURI endpointUri, String filterAddress) {
        this.initialise(endpointUri);
        this.filterAddress = filterAddress;
    }

    public MuleEndpointURI(String uri) throws EndpointException {
        uri = uri.trim().replaceAll(" ", "%20");
        if (!this.validateUrl(uri)) {
            throw new MalformedEndpointException(uri);
        }
        try {
            this.schemeMetaInfo = this.retrieveSchemeMetaInfo(uri);
            if (this.schemeMetaInfo != null) {
                uri = uri.replaceFirst(this.schemeMetaInfo + ":", "");
            }
            this.uri = new URI(uri);
            this.userInfo = this.uri.getRawUserInfo();
        }
        catch (URISyntaxException e) {
            throw new MalformedEndpointException(uri, (Throwable)e);
        }
    }

    public LifecycleTransitionResult initialise() throws InitialisationException {
        try {
            String scheme = this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
            TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            EndpointURIBuilder builder = sd.createEndpointBuilder();
            EndpointURI built = builder.build(this.uri);
            this.initialise(built);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        return LifecycleTransitionResult.OK;
    }

    private String retrieveSchemeMetaInfo(String url) {
        int i = url.indexOf(58);
        if (i == -1) {
            return null;
        }
        if (url.charAt(i + 1) == '/') {
            return null;
        }
        return url.substring(0, i);
    }

    protected boolean validateUrl(String url) {
        return url.indexOf(":/") > 0;
    }

    private void initialise(EndpointURI endpointUri) {
        this.address = endpointUri.getAddress();
        if (this.endpointName == null) {
            this.endpointName = endpointUri.getEndpointName();
        }
        this.connectorName = endpointUri.getConnectorName();
        this.transformers = endpointUri.getTransformers();
        this.responseTransformers = endpointUri.getResponseTransformers();
        this.params = endpointUri.getParams();
        this.uri = endpointUri.getUri();
        this.resourceInfo = endpointUri.getResourceInfo();
        this.userInfo = endpointUri.getUserInfo();
    }

    public String getAddress() {
        return this.address;
    }

    public String getEndpointName() {
        return StringUtils.isEmpty((String)this.endpointName) ? null : this.endpointName;
    }

    public Properties getParams() {
        if (this.params.size() == 0 && this.getQuery() != null) {
            this.params = PropertiesUtils.getPropertiesFromQueryString(this.getQuery());
        }
        return this.params;
    }

    public Properties getUserParams() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getParams());
        p.remove("endpointName");
        p.remove("address");
        p.remove("transformers");
        return p;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return this.uri.parseServerAuthority();
    }

    public URI normalize() {
        return this.uri.normalize();
    }

    public URI resolve(URI uri) {
        return uri.resolve(uri);
    }

    public URI resolve(String str) {
        return this.uri.resolve(str);
    }

    public URI relativize(URI uri) {
        return uri.relativize(uri);
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getFullScheme() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo + ':' + this.uri.getScheme();
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.uri.isOpaque();
    }

    public String getRawSchemeSpecificPart() {
        return this.uri.getRawSchemeSpecificPart();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getRawAuthority() {
        return this.uri.getRawAuthority();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getRawUserInfo() {
        return this.uri.getRawUserInfo();
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getRawPath() {
        return this.uri.getRawPath();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getRawQuery() {
        return this.uri.getRawQuery();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getRawFragment() {
        return this.uri.getRawFragment();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    public String getTransformers() {
        return this.transformers;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getSchemeMetaInfo() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
    }

    public String getResourceInfo() {
        return this.resourceInfo;
    }

    public String getFilterAddress() {
        return this.filterAddress;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
    }

    public String getUser() {
        if (StringUtils.isNotBlank((String)this.userInfo)) {
            int i = this.userInfo.indexOf(58);
            if (i == -1) {
                return this.userInfo;
            }
            return this.userInfo.substring(0, i);
        }
        return null;
    }

    public String getResponseTransformers() {
        return this.responseTransformers;
    }

    public String getPassword() {
        int i;
        if (StringUtils.isNotBlank((String)this.userInfo) && (i = this.userInfo.indexOf(58)) > -1) {
            return this.userInfo.substring(i + 1);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEndpointURI)) {
            return false;
        }
        MuleEndpointURI muleEndpointURI = (MuleEndpointURI)o;
        return ClassUtils.equal(this.address, muleEndpointURI.address) && ClassUtils.equal(this.connectorName, muleEndpointURI.connectorName) && ClassUtils.equal(this.endpointName, muleEndpointURI.endpointName) && ClassUtils.equal(this.filterAddress, muleEndpointURI.filterAddress) && ClassUtils.equal(this.params, muleEndpointURI.params) && ClassUtils.equal(this.resourceInfo, muleEndpointURI.resourceInfo) && ClassUtils.equal(this.schemeMetaInfo, muleEndpointURI.schemeMetaInfo) && ClassUtils.equal(this.transformers, muleEndpointURI.transformers) && ClassUtils.equal(this.responseTransformers, muleEndpointURI.responseTransformers) && ClassUtils.equal(this.uri, muleEndpointURI.uri);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.address, this.filterAddress, this.endpointName, this.connectorName, this.transformers, this.responseTransformers, this.params, this.uri, this.schemeMetaInfo, this.resourceInfo});
    }
}

