/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import edu.emory.mathcs.backport.java.util.Collections;
import org.mule.DefaultMuleEventContext;
import org.mule.VoidResult;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.ModelException;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.object.SingletonObjectFactory;
import org.mule.transformer.TransformerTemplate;

public class SimpleCallableJavaComponent
extends AbstractJavaComponent {
    private boolean started = false;
    private boolean disposed = false;

    public SimpleCallableJavaComponent() {
    }

    public SimpleCallableJavaComponent(Callable callable) {
        this.objectFactory = new SingletonObjectFactory(callable);
    }

    public SimpleCallableJavaComponent(Class callable) throws DefaultMuleException {
        if (!Callable.class.isAssignableFrom(callable)) {
            throw new DefaultMuleException(CoreMessages.objectNotOfCorrectType(callable, Callable.class));
        }
        this.objectFactory = new SingletonObjectFactory(callable);
    }

    public SimpleCallableJavaComponent(ObjectFactory objectFactory) throws DefaultMuleException {
        if (!Callable.class.isAssignableFrom(objectFactory.getObjectClass())) {
            throw new DefaultMuleException(CoreMessages.objectNotOfCorrectType(objectFactory.getObjectClass(), Callable.class));
        }
        this.objectFactory = objectFactory;
    }

    protected void doStart() throws MuleException {
        super.doStart();
        if (Startable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Startable)this.objectFactory.getInstance()).start();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStart("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    protected void doStop() throws MuleException {
        super.doStop();
        if (this.started && Stoppable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Stoppable)this.objectFactory.getInstance()).stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    protected void doDispose() {
        super.doDispose();
        if (Disposable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Disposable)this.objectFactory.getInstance()).dispose();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to dispose component instance", (Throwable)e);
            }
        }
    }

    public Class getObjectType() {
        if (this.objectFactory != null) {
            return this.objectFactory.getObjectClass();
        }
        return Callable.class;
    }

    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        return null;
    }

    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) {
    }

    protected MuleMessage invokeComponentInstance(MuleEvent event) throws Exception {
        Object result = ((Callable)this.objectFactory.getInstance()).onCall(new DefaultMuleEventContext(event));
        if (result instanceof VoidResult) {
            event.transformMessage();
            return event.getMessage();
        }
        if (result != null) {
            if (result instanceof MuleMessage) {
                return (MuleMessage)result;
            }
            event.getMessage().applyTransformers(Collections.singletonList((Object)new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event.getMessage();
        }
        return null;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        if (!Callable.class.isAssignableFrom(objectFactory.getObjectClass())) {
            throw new MuleRuntimeException(CoreMessages.objectNotOfCorrectType(objectFactory.getObjectClass(), Callable.class));
        }
        super.setObjectFactory(objectFactory);
    }
}

