/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.VoidResult;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.interceptor.Invocation;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.routing.NestedRouter;
import org.mule.api.service.ServiceAware;
import org.mule.api.service.ServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.ClassUtils;

public class DefaultLifecycleAdapter
implements LifecycleAdapter {
    protected static final Log logger = LogFactory.getLog(DefaultLifecycleAdapter.class);
    protected Object componentObject;
    protected JavaComponent component;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private EntryPointResolverSet entryPointResolver;

    public DefaultLifecycleAdapter(Object componentObject, JavaComponent component) throws MuleException {
        this(componentObject, component, new LegacyEntryPointResolverSet());
    }

    public DefaultLifecycleAdapter(Object componentObject, JavaComponent component, EntryPointResolverSet entryPointResolver) throws MuleException {
        if (componentObject == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (entryPointResolver == null) {
            entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.componentObject = componentObject;
        this.component = component;
        this.entryPointResolver = entryPointResolver;
        this.isStartable = Startable.class.isInstance(componentObject);
        this.isStoppable = Stoppable.class.isInstance(componentObject);
        this.isDisposable = Disposable.class.isInstance(componentObject);
        if (componentObject instanceof ServiceAware) {
            ((ServiceAware)componentObject).setService(component.getService());
        }
        this.configureNestedRouter();
    }

    public LifecycleTransitionResult start() throws MuleException {
        if (this.isStartable) {
            try {
                return LifecycleTransitionResult.startOrStopAll(((Startable)this.componentObject).start(), new LifecycleTransitionResult.Closure(){

                    public LifecycleTransitionResult doContinue() {
                        DefaultLifecycleAdapter.this.started = true;
                        return LifecycleTransitionResult.OK;
                    }
                });
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("UMO Service: " + this.component.getService().getName()), (Throwable)e);
            }
        }
        this.started = true;
        return LifecycleTransitionResult.OK;
    }

    public LifecycleTransitionResult stop() throws MuleException {
        if (this.isStoppable) {
            try {
                return LifecycleTransitionResult.startOrStopAll(((Stoppable)this.componentObject).stop(), new LifecycleTransitionResult.Closure(){

                    public LifecycleTransitionResult doContinue() {
                        DefaultLifecycleAdapter.this.started = false;
                        return LifecycleTransitionResult.OK;
                    }
                });
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("UMO Service: " + this.component.getService().getName()), (Throwable)e);
            }
        }
        this.started = false;
        return LifecycleTransitionResult.OK;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                ((Disposable)this.componentObject).dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.component.getService().getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        Object result;
        MuleEvent event = RequestContext.getEvent();
        try {
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.componentObject, RequestContext.getEventContext()) : this.entryPointResolver.invoke(this.componentObject, RequestContext.getEventContext());
        }
        catch (Exception e) {
            throw new ServiceException(RequestContext.getEventContext().getMessage(), this.component.getService(), (Throwable)e);
        }
        MuleMessage resultMessage = null;
        if (result instanceof VoidResult) {
            event.transformMessage();
            resultMessage = event.getMessage();
        } else if (result != null) {
            if (result instanceof MuleMessage) {
                resultMessage = (MuleMessage)result;
            } else {
                event.getMessage().applyTransformers(Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
                resultMessage = event.getMessage();
            }
        }
        return resultMessage;
    }

    public LifecycleTransitionResult initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.componentObject)) {
            ((Initialisable)this.componentObject).initialise();
        }
        return LifecycleTransitionResult.OK;
    }

    protected void configureNestedRouter() throws MuleException {
        if (this.component.getNestedRouter() != null) {
            HashMap bindings = new HashMap();
            for (NestedRouter nestedRouter : this.component.getNestedRouter().getRouters()) {
                Object proxy = bindings.get(nestedRouter.getInterface());
                if (proxy == null) {
                    proxy = nestedRouter.createProxy(this.componentObject);
                    bindings.put(nestedRouter.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.componentObject.getClass(), new Class[]{nestedRouter.getInterface()});
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.componentObject, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(nestedRouter, this.componentObject.getClass()), (Throwable)e, this);
                    }
                }
                NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(nestedRouter);
            }
        }
    }
}

