/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.Collection;
import java.util.Iterator;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.component.LifecycleAdapterFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.ReplyToHandler;
import org.mule.component.AbstractComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultExceptionPayload;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.routing.nested.DefaultNestedRouterCollection;
import org.mule.transport.NullPayload;

public abstract class AbstractJavaComponent
extends AbstractComponent
implements JavaComponent {
    protected EntryPointResolverSet entryPointResolverSet;
    protected NestedRouterCollection nestedRouter = new DefaultNestedRouterCollection();
    protected ObjectFactory objectFactory;
    protected LifecycleAdapterFactory lifecycleAdapterFactory;

    public AbstractJavaComponent() {
    }

    public AbstractJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null, null);
    }

    public AbstractJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet, NestedRouterCollection nestedRouterCollection) {
        this.objectFactory = objectFactory;
        this.entryPointResolverSet = entryPointResolverSet;
        if (nestedRouterCollection != null) {
            this.nestedRouter = nestedRouterCollection;
        }
    }

    protected MuleMessage doOnCall(MuleEvent event) {
        MessageAdapter returnMessage = null;
        try {
            String requestor;
            InboundEndpoint endpoint = (InboundEndpoint)event.getEndpoint();
            event = OptimizedRequestContext.unsafeSetEvent(event);
            Object replyTo = event.getMessage().getReplyTo();
            ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), endpoint);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            returnMessage = this.invokeComponentInstance(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            if (event.isStopFurtherProcessing()) {
                this.logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
            }
            if (returnMessage != null && !event.isStopFurtherProcessing()) {
                if (this.service.getOutboundRouter().hasEndpoints()) {
                    MuleMessage outboundReturnMessage = this.service.getOutboundRouter().route((MuleMessage)returnMessage, event.getSession(), event.isSynchronous());
                    if (outboundReturnMessage != null) {
                        returnMessage = outboundReturnMessage;
                    }
                } else {
                    this.logger.debug((Object)("Outbound router on service '" + this.service.getName() + "' doesn't have any endpoints configured."));
                }
            }
            if (returnMessage != null && this.service.getResponseRouter() != null) {
                this.logger.debug((Object)"Waiting for response router message");
                returnMessage = this.service.getResponseRouter().getResponse((MuleMessage)returnMessage);
            }
            if (returnMessage != null && replyToHandler != null && ((requestor = (String)returnMessage.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
                replyToHandler.processReplyTo(event, (MuleMessage)returnMessage, replyTo);
            }
            if (this.statistics.isEnabled()) {
                this.statistics.incSentEventSync();
            }
        }
        catch (Exception e) {
            ExceptionPayload exceptionPayload;
            event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), event.getMessage(), (Throwable)e));
            }
            if (returnMessage == null) {
                returnMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), RequestContext.getEvent().getMessage());
            }
            if ((exceptionPayload = returnMessage.getExceptionPayload()) == null) {
                exceptionPayload = new DefaultExceptionPayload(e);
            }
            returnMessage.setExceptionPayload(exceptionPayload);
        }
        return returnMessage;
    }

    protected void doOnEvent(MuleEvent event) {
        try {
            String requestor;
            InboundEndpoint endpoint = (InboundEndpoint)event.getEndpoint();
            event = OptimizedRequestContext.criticalSetEvent(event);
            Object replyTo = event.getMessage().getReplyTo();
            ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), endpoint);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            MuleMessage result = this.invokeComponentInstance(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            event = RequestContext.getEvent();
            if (result != null && !event.isStopFurtherProcessing() && this.service.getOutboundRouter().hasEndpoints()) {
                this.service.getOutboundRouter().route(result, event.getSession(), event.isSynchronous());
            }
            if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
                replyToHandler.processReplyTo(event, result, replyTo);
            }
            if (this.statistics.isEnabled()) {
                this.statistics.incSentEventASync();
            }
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            }
            this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), event.getMessage(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage invokeComponentInstance(MuleEvent event) throws Exception {
        LifecycleAdapter componentLifecycleAdapter = null;
        try {
            componentLifecycleAdapter = this.borrowComponentLifecycleAdaptor();
            MuleMessage muleMessage = componentLifecycleAdapter.intercept(null);
            return muleMessage;
        }
        finally {
            this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
        }
    }

    public Class getObjectType() {
        return this.objectFactory.getObjectClass();
    }

    protected LifecycleAdapter createLifeCycleAdaptor() throws MuleException, Exception {
        LifecycleAdapter lifecycleAdapter = this.lifecycleAdapterFactory != null ? this.lifecycleAdapterFactory.create(this.objectFactory.getInstance(), this, this.entryPointResolverSet) : this.service.getModel().getLifecycleAdapterFactory().create(this.objectFactory.getInstance(), this, this.entryPointResolverSet);
        lifecycleAdapter.initialise();
        return lifecycleAdapter;
    }

    protected abstract LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception;

    protected abstract void returnComponentLifecycleAdaptor(LifecycleAdapter var1) throws Exception;

    protected void doInitialise() throws InitialisationException {
        if (this.objectFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("object factory"), (Initialisable)this);
        }
        this.objectFactory.initialise();
    }

    protected void doStart() throws MuleException {
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = this.service.getModel().getEntryPointResolverSet();
        }
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
    }

    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public NestedRouterCollection getNestedRouter() {
        return this.nestedRouter;
    }

    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setNestedRouter(NestedRouterCollection nestedRouter) {
        this.nestedRouter = nestedRouter;
    }

    public void setEntryPointResolvers(Collection entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        Iterator resolvers = entryPointResolvers.iterator();
        while (resolvers.hasNext()) {
            this.entryPointResolverSet.addEntryPointResolver((EntryPointResolver)resolvers.next());
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }
}

