/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.DisposeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.management.stats.ComponentStatistics;
import org.mule.transport.AbstractConnector;

public abstract class AbstractComponent
implements Component {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Service service;
    protected ComponentStatistics statistics = null;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean stopping = new AtomicBoolean(false);
    protected final AtomicBoolean initialised = new AtomicBoolean(false);
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected final AtomicBoolean disposed = new AtomicBoolean(false);

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
    }

    public MuleMessage onCall(MuleEvent event) throws MuleException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getClass().getName() + ": sync call for Mule Component " + this.service.getName()));
        }
        this.checkDisposed();
        if (!(event.getEndpoint() instanceof InboundEndpoint)) {
            throw new IllegalStateException("Unable to process outbound event, components only process incoming events.");
        }
        if (this.stopping.get() || !this.started.get()) {
            throw new DefaultMuleException(CoreMessages.componentIsStopped(this.service.getName()));
        }
        try {
            return this.doOnCall(event);
        }
        catch (Exception e) {
            throw new ServiceException(CoreMessages.failedToInvoke(this.toString()), event.getMessage(), this.service, e);
        }
    }

    public void onEvent(MuleEvent event) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getClass().getName() + ": async call for Mule Component " + this.service.getName()));
        }
        try {
            this.checkDisposed();
            if (!(event.getEndpoint() instanceof InboundEndpoint)) {
                throw new IllegalStateException("Unable to process outbound event, components only process incoming events.");
            }
            if (this.stopping.get() || !this.started.get()) {
                throw new DefaultMuleException(CoreMessages.componentIsStopped(this.service.getName()));
            }
            this.doOnEvent(event);
        }
        catch (Exception e) {
            this.logger.error((Object)new ServiceException(CoreMessages.failedToInvoke(this.toString()), event.getMessage(), this.service, e));
        }
    }

    protected abstract MuleMessage doOnCall(MuleEvent var1);

    protected abstract void doOnEvent(MuleEvent var1);

    public void handleException(Exception exception) {
        this.service.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "proxy for: " + this.service.toString();
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, InboundEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    public void release() {
    }

    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public LifecycleTransitionResult initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Initialising: " + this));
            }
            if (this.service == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Component has not been initialized properly, no service."), (Initialisable)this);
            }
            this.doInitialise();
            this.initialised.set(true);
        }
        return LifecycleTransitionResult.OK;
    }

    protected abstract void doInitialise() throws InitialisationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposing.set(true);
        try {
            if (this.started.get()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)CoreMessages.failedToStop(this.toString()));
        }
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.warn(CoreMessages.failedToDispose(this.toString()), (Throwable)e);
        }
        finally {
            this.disposed.set(true);
            this.disposing.set(false);
            this.initialised.set(false);
        }
    }

    protected abstract void doDispose();

    public LifecycleTransitionResult stop() throws MuleException {
        if (!this.disposed.get() && this.started.get() && !this.stopping.get()) {
            this.stopping.set(true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping: " + this));
            }
            this.doStop();
            this.started.set(false);
            this.stopping.set(false);
        }
        return LifecycleTransitionResult.OK;
    }

    protected abstract void doStart() throws MuleException;

    public LifecycleTransitionResult start() throws MuleException {
        this.checkDisposed();
        if (!this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting: " + this));
            }
            this.doStart();
            this.started.set(true);
        }
        return LifecycleTransitionResult.OK;
    }

    protected abstract void doStop() throws MuleException;

    protected void checkDisposed() throws DisposeException {
        if (this.disposed.get()) {
            throw new DisposeException(CoreMessages.createStaticMessage("Cannot use a disposed component"), (Disposable)this);
        }
    }
}

