/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;

public final class LifecycleTransitionResult {
    public static final String OK_NAME = "ok";
    public static final String RETRY_NAME = "retry";
    public static final LifecycleTransitionResult OK = new LifecycleTransitionResult("ok", true, null, null);
    private boolean ok;
    private Throwable throwable;
    private Object target;
    private String name;

    private LifecycleTransitionResult(String name, boolean ok, Throwable throwable, Object target) {
        this.name = name;
        this.ok = ok;
        this.throwable = throwable;
        this.target = target;
    }

    public static LifecycleTransitionResult retry(Throwable throwable, Object target) {
        return new LifecycleTransitionResult(RETRY_NAME, false, throwable, target);
    }

    public boolean isOk() {
        return this.ok;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return ClassUtils.getSimpleName(this.getClass()) + ": " + this.name;
    }

    public LifecycleException nestedRetryLifecycleException() {
        return (LifecycleException)new LifecycleException(CoreMessages.nestedRetry(), this.target).initCause(this.throwable);
    }

    public InitialisationException nestedRetryInitialisationException() {
        return (InitialisationException)new InitialisationException(CoreMessages.nestedRetry(), (Initialisable)this.target).initCause(this.throwable);
    }

    private static LifecycleTransitionResult processAllNoRetry(Class iface, Iterator objects) throws LifecycleException {
        Class<?> exception;
        if (!iface.isAssignableFrom(Lifecycle.class)) {
            throw new IllegalArgumentException("Not a Lifecycle interface: " + iface);
        }
        Method method = iface.getMethods()[0];
        boolean hasException = method.getExceptionTypes().length > 0;
        Class<?> clazz = exception = hasException ? method.getExceptionTypes()[0] : null;
        while (objects.hasNext()) {
            Object target = objects.next();
            LifecycleTransitionResult.processSingleNoRetry(target, method, exception, iface);
        }
        return OK;
    }

    private static LifecycleTransitionResult processSingleNoRetry(Object target, Method method, Class exception, Class iface) throws LifecycleException {
        if (!iface.isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException(ClassUtils.getSimpleName(target.getClass()) + " is not an " + ClassUtils.getSimpleName(iface));
        }
        try {
            LifecycleTransitionResult result = (LifecycleTransitionResult)method.invoke(target, ClassUtils.NO_ARGS);
            if (!LifecycleTransitionResult.isOk(result)) {
                if (null != exception) {
                    if (exception.equals(InitialisationException.class)) {
                        throw result.nestedRetryInitialisationException();
                    }
                    throw result.nestedRetryLifecycleException();
                }
                IllegalStateException error = new IllegalStateException("Unexpected state from transition: " + result);
                error.initCause(result.getThrowable());
                throw error;
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unsupported interface: " + iface).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unsupported interface: " + iface).initCause(e);
        }
    }

    public static LifecycleTransitionResult initialiseAll(Iterator children) throws InitialisationException {
        try {
            return LifecycleTransitionResult.processAllNoRetry(Initialisable.class, children);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw (IllegalStateException)new IllegalStateException("Unexpected exception: " + e).initCause(e);
        }
    }

    public static LifecycleTransitionResult initialiseAll(LifecycleTransitionResult status, final Iterator children) throws InitialisationException {
        return LifecycleTransitionResult.initialiseAll(status, new Closure(){

            public LifecycleTransitionResult doContinue() throws LifecycleException {
                return LifecycleTransitionResult.initialiseAll(children);
            }
        });
    }

    public static LifecycleTransitionResult initialiseAll(LifecycleTransitionResult status, Closure rest) throws InitialisationException {
        if (LifecycleTransitionResult.isOk(status)) {
            try {
                return rest.doContinue();
            }
            catch (InitialisationException e) {
                throw e;
            }
            catch (MuleException e) {
                throw (IllegalStateException)new IllegalStateException("Unexpected exception: " + e).initCause(e);
            }
        }
        throw status.nestedRetryInitialisationException();
    }

    public static LifecycleTransitionResult startOrStopAll(LifecycleTransitionResult status, Closure rest) throws MuleException {
        if (LifecycleTransitionResult.isOk(status)) {
            return rest.doContinue();
        }
        throw status.nestedRetryLifecycleException();
    }

    public static boolean isOk(LifecycleTransitionResult result) {
        return null != result && result.isOk();
    }

    public static interface Closure {
        public LifecycleTransitionResult doContinue() throws MuleException;
    }
}

