/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.object;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.object.ObjectFactory;

public abstract class AbstractObjectFactory
implements ObjectFactory,
ServiceAware {
    public static final String ATTRIBUTE_OBJECT_CLASS_NAME = "objectClassName";
    public static final String ATTRIBUTE_OBJECT_CLASS = "objectClass";
    protected String objectClassName;
    protected Class objectClass = null;
    protected Map properties = null;
    Service service;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
    }

    public AbstractObjectFactory(Class objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class objectClass, Map properties) {
        this.objectClass = objectClass;
        this.properties = properties;
    }

    public void initialise() throws InitialisationException {
        if (this.objectClass == null && this.objectClassName != null) {
            try {
                this.objectClass = ClassUtils.getClass((String)this.objectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public Object getOrCreate() throws Exception {
        Object object = ClassUtils.instanciateClass(this.objectClass, ClassUtils.NO_ARGS);
        if (this.properties != null) {
            BeanUtils.populate((Object)object, (Map)this.properties);
        }
        if (this.service != null) {
            BeanUtils.setProperty((Object)object, (String)"service", (Object)this.service);
        }
        if (object instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
        return object;
    }

    public void setService(Service service) throws ConfigurationException {
        this.service = service;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    protected String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    protected Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

