/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.StringMessageUtils;

public final class DebugOptions {
    protected static final Log logger = LogFactory.getLog(DebugOptions.class);
    private static boolean cacheMessageAsBytes = DebugOptions.getBooleanOption("org.mule.message.cacheBytes", true);
    private static boolean cacheMessageOriginalPayload = DebugOptions.getBooleanOption("org.mule.message.cacheOriginal", true);
    private static boolean enableStreaming = DebugOptions.getBooleanOption("org.mule.streaming.enable", true);
    private static boolean assertMessageAccess = DebugOptions.getBooleanOption("org.mule.message.assertAccess", true);
    private static boolean autoWrapMessageAwareTransform = DebugOptions.getBooleanOption("org.mule.transform.autoWrap", true);

    private static boolean getBooleanOption(String name, boolean defaultValue) {
        String prop = System.getProperty(name, null);
        if (prop == null) {
            return defaultValue;
        }
        return Boolean.valueOf(prop);
    }

    public static boolean isCacheMessageAsBytes() {
        return cacheMessageAsBytes;
    }

    public static void setCacheMessageAsBytes(boolean cacheMessageAsBytes) {
        if (DebugOptions.isCacheMessageAsBytes() != cacheMessageAsBytes) {
            DebugOptions.assertChange("org.mule.message.cacheBytes", String.valueOf(cacheMessageAsBytes));
        }
        DebugOptions.cacheMessageAsBytes = cacheMessageAsBytes;
    }

    public static boolean isCacheMessageOriginalPayload() {
        return cacheMessageOriginalPayload;
    }

    public static void setCacheMessageOriginalPayload(boolean cacheMessageOriginalPayload) {
        if (DebugOptions.isCacheMessageOriginalPayload() != cacheMessageOriginalPayload) {
            DebugOptions.assertChange("org.mule.message.cacheOriginal", String.valueOf(cacheMessageOriginalPayload));
        }
        DebugOptions.cacheMessageOriginalPayload = cacheMessageOriginalPayload;
    }

    public static boolean isEnableStreaming() {
        return enableStreaming;
    }

    public static void setEnableStreaming(boolean enableStreaming) {
        if (DebugOptions.isEnableStreaming() != enableStreaming) {
            DebugOptions.assertChange("org.mule.streaming.enable", String.valueOf(enableStreaming));
        }
        DebugOptions.enableStreaming = enableStreaming;
    }

    public static boolean isAssertMessageAccess() {
        return assertMessageAccess;
    }

    public static void setAssertMessageAccess(boolean assertMessageAccess) {
        if (DebugOptions.isAssertMessageAccess() != assertMessageAccess) {
            DebugOptions.assertChange("org.mule.message.assertAccess", String.valueOf(assertMessageAccess));
        }
        DebugOptions.assertMessageAccess = assertMessageAccess;
    }

    protected static void assertChange(String property, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringMessageUtils.getBoilerPlate("Debug property changed is now: " + property + "=" + value));
        }
    }

    public static boolean isAutoWrapMessageAwareTransform() {
        return autoWrapMessageAwareTransform;
    }

    public static void setAutoWrapMessageAwareTransform(boolean autoWrapMessageAwareTransform) {
        if (DebugOptions.isAutoWrapMessageAwareTransform() != autoWrapMessageAwareTransform) {
            DebugOptions.assertChange("org.mule.transform.autoWrap", String.valueOf(autoWrapMessageAwareTransform));
        }
        DebugOptions.autoWrapMessageAwareTransform = autoWrapMessageAwareTransform;
    }

    public static void logDebugOptions() {
        if (logger.isDebugEnabled()) {
            ArrayList<String> values = new ArrayList<String>(5);
            values.add("Mule Debug Options:");
            values.add("org.mule.message.cacheBytes=" + DebugOptions.isCacheMessageAsBytes());
            values.add("org.mule.message.cacheOriginal=" + DebugOptions.isCacheMessageOriginalPayload());
            values.add("org.mule.message.assertAccess=" + DebugOptions.isAssertMessageAccess());
            values.add("org.mule.streaming.enable=" + DebugOptions.isEnableStreaming());
            values.add("org.mule.transform.autoWrap=" + DebugOptions.isAutoWrapMessageAwareTransform());
            logger.debug((Object)StringMessageUtils.getBoilerPlate(values, '*', 80));
        }
    }

    static {
        DebugOptions.logDebugOptions();
    }
}

