/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.MapUtils;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static final Object[] NO_ARGS = new Object[0];
    public static final Class[] NO_ARGS_TYPE = new Class[0];
    private static final Map wrapperToPrimitiveMap = new HashMap();

    public static boolean isConcrete(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz may not be null");
        }
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static URL getResource(final String resourceName, final Class callingClass) {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader().getResource(resourceName);
            }
        });
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassUtils.class.getClassLoader().getResource(resourceName);
                }
            });
        }
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return callingClass.getClassLoader().getResource(resourceName);
                }
            });
        }
        return url;
    }

    public static Enumeration getResources(final String resourceName, final Class callingClass) {
        Enumeration enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Thread.currentThread().getContextClassLoader().getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        if (enumeration == null) {
            enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ClassUtils.class.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        if (enumeration == null) {
            enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return callingClass.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        return enumeration;
    }

    public static Class loadClass(final String className, final Class callingClass) throws ClassNotFoundException {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        });
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ClassUtils.class.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return callingClass.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    public static void printClassLoader() {
        System.out.println("ClassLoaderUtils.printClassLoader");
        ClassUtils.printClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void printClassLoader(ClassLoader cl) {
        System.out.println("ClassLoaderUtils.printClassLoader(cl = " + cl + ")");
        if (cl != null) {
            ClassUtils.printClassLoader(cl.getParent());
        }
    }

    public static Class initializeClass(Class clazz) {
        try {
            return ClassUtils.getClass((String)clazz.getName(), (boolean)true);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException();
        }
    }

    public static Object instanciateClass(Class clazz, Object[] constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassUtils.getConstructor(clazz, args)) == null) {
            ctor = ClassUtils.getConstructor(clazz, ClassUtils.wrappersToPrimitives(args));
        }
        if (ctor == null) {
            StringBuffer argsString = new StringBuffer(100);
            for (int i = 0; i < args.length; ++i) {
                argsString.append(args[i].getName()).append(", ");
            }
            throw new NoSuchMethodException("could not find constructor with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassUtils.loadClass(name, ClassUtils.class);
        return ClassUtils.instanciateClass(clazz, constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs, Class callingClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassUtils.loadClass(name, callingClass);
        return ClassUtils.instanciateClass(clazz, constructorArgs);
    }

    public static Class[] getParameterTypes(Object bean, String methodName) {
        if (!methodName.startsWith("set")) {
            methodName = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        }
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i].getParameterTypes();
        }
        return new Class[0];
    }

    public static Method getMethod(Class clazz, String name, Class[] parameterTypes) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            if (parameterTypes == null) {
                return methods[i];
            }
            if (!ClassUtils.compare(methods[i].getParameterTypes(), parameterTypes, true)) continue;
            return methods[i];
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] types = ctors[i].getParameterTypes();
            if (types.length != paramTypes.length) continue;
            boolean match = true;
            for (int x = 0; x < types.length; ++x) {
                match = paramTypes[x] == null ? true : types[x].isAssignableFrom(paramTypes[x]);
            }
            if (!match) continue;
            return ctors[i];
        }
        return null;
    }

    public static List getSatisfiableMethods(Class implementation, Class[] parameterTypes, boolean voidOk, boolean matchOnObject, Set ignoredMethodNames) {
        return ClassUtils.getSatisfiableMethods(implementation, parameterTypes, voidOk, matchOnObject, ignoredMethodNames, null);
    }

    public static List getSatisfiableMethods(Class implementation, Class[] parameterTypes, boolean voidOk, boolean matchOnObject, Collection ignoredMethodNames, WildcardFilter filter) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (ignoredMethodNames == null) {
            ignoredMethodNames = Collections.EMPTY_SET;
        }
        Method[] methods = implementation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String returnType;
            Class[] methodParams;
            Method method = methods[i];
            if (filter != null && filter.accept(method.getName()) || !ClassUtils.compare(methodParams = method.getParameterTypes(), parameterTypes, matchOnObject) || ignoredMethodNames.contains(method.getName()) || (!(returnType = method.getReturnType().getName()).equals("void") || !voidOk) && returnType.equals("void")) continue;
            result.add(method);
        }
        return result;
    }

    public static List getSatisfiableMethodsWithReturnType(Class implementation, Class returnType, boolean matchOnObject, Set ignoredMethodNames) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (ignoredMethodNames == null) {
            ignoredMethodNames = Collections.EMPTY_SET;
        }
        Method[] methods = implementation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> returns = method.getReturnType();
            if (!ClassUtils.compare(new Class[]{returns}, new Class[]{returnType}, matchOnObject) || ignoredMethodNames.contains(method.getName())) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassUtils.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class[] getClassTypes(Object object) {
        Class[] types;
        if (object == null) {
            return NO_ARGS_TYPE;
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            if (objects.length == 0) {
                return NO_ARGS_TYPE;
            }
            types = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                types[i] = objects[i].getClass();
            }
        } else {
            types = new Class[]{object.getClass()};
        }
        return types;
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static boolean compare(Class[] c1, Class[] c2, boolean matchOnObject) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i].equals(Object.class) && !matchOnObject) {
                return false;
            }
            if (c1[i].isAssignableFrom(c2[i])) continue;
            return false;
        }
        return true;
    }

    public static Class wrapperToPrimitive(Class wrapper) {
        return (Class)MapUtils.getObject((Map)wrapperToPrimitiveMap, (Object)wrapper, (Object)wrapper);
    }

    public static Class[] wrappersToPrimitives(Class[] wrappers) {
        if (wrappers == null) {
            return null;
        }
        if (wrappers.length == 0) {
            return wrappers;
        }
        Class[] primitives = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            primitives[i] = (Class)MapUtils.getObject((Map)wrapperToPrimitiveMap, (Object)wrappers[i], (Object)wrappers[i]);
        }
        return primitives;
    }

    public static String getSimpleName(Class clazz) {
        if (null == clazz) {
            return "null";
        }
        return ClassUtils.classNameHelper(new BufferedReader(new CharArrayReader(clazz.getName().toCharArray())));
    }

    private static String classNameHelper(Reader encodedName) {
        try {
            encodedName.mark(1);
            switch (encodedName.read()) {
                case -1: {
                    return "null";
                }
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 68: {
                    return "double";
                }
                case 70: {
                    return "float";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 83: {
                    return "short";
                }
                case 91: {
                    return ClassUtils.classNameHelper(encodedName) + "[]";
                }
                case 76: {
                    return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
                }
            }
            encodedName.reset();
            return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
        }
        catch (IOException e) {
            return "unknown type: " + e.getMessage();
        }
    }

    private static String shorten(String clazz) {
        if (null != clazz && clazz.endsWith(";")) {
            clazz = clazz.substring(0, clazz.length() - 1);
        }
        if (null != clazz && clazz.lastIndexOf(".") > -1) {
            clazz = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
        }
        return clazz;
    }

    public static boolean equal(Object a, Object b) {
        if (null == a) {
            return null == b;
        }
        return null != b && a.equals(b);
    }

    public static int hash(Object[] state) {
        int hash = 0;
        for (int i = 0; i < state.length; ++i) {
            hash = hash * 31 + (null == state[i] ? 0 : state[i].hashCode());
        }
        return hash;
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Void.TYPE, Void.TYPE);
    }
}

