/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.service;

import java.util.List;
import java.util.Properties;
import org.mule.MuleSessionHandler;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.Registry;
import org.mule.api.service.Service;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.UrlEndpointURIBuilder;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.NullPayload;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.object.ObjectFactory;

public class DefaultTransportServiceDescriptor
extends AbstractServiceDescriptor
implements TransportServiceDescriptor {
    private String connector;
    private String connectorFactory;
    private String dispatcherFactory;
    private String requesterFactory;
    private String transactionFactory;
    private String messageAdapter;
    private String messageReceiver;
    private String transactedMessageReceiver;
    private String xaTransactedMessageReceiver;
    private String endpointBuilder;
    private String sessionHandler;
    private String defaultInboundTransformer;
    private String defaultOutboundTransformer;
    private String defaultResponseTransformer;
    private Transformer inboundTransformer;
    private Transformer outboundTransformer;
    private Transformer responseTransformer;
    private Properties exceptionMappings = new Properties();

    public DefaultTransportServiceDescriptor(String service, Properties props, Registry registry) {
        super(service);
        this.connector = this.removeProperty("connector", props);
        this.connectorFactory = this.removeProperty("connector.factory", props);
        this.dispatcherFactory = this.removeProperty("dispatcher.factory", props);
        this.requesterFactory = this.removeProperty("requester.factory", props);
        this.transactionFactory = this.removeProperty("dispatcher.factory", props);
        this.messageReceiver = this.removeProperty("message.receiver", props);
        this.transactedMessageReceiver = this.removeProperty("transacted.message.receiver", props);
        this.xaTransactedMessageReceiver = this.removeProperty("xa.transacted.message.receiver", props);
        this.messageAdapter = this.removeProperty("message.adapter", props);
        this.defaultInboundTransformer = this.removeProperty("inbound.transformer", props);
        this.defaultOutboundTransformer = this.removeProperty("outbound.transformer", props);
        this.defaultResponseTransformer = this.removeProperty("response.transformer", props);
        this.endpointBuilder = this.removeProperty("endpoint.builder", props);
        this.sessionHandler = this.removeProperty("session.handler", props);
    }

    public void setOverrides(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.connector = props.getProperty("connector", this.connector);
        this.connectorFactory = props.getProperty("connector.factory", this.connectorFactory);
        this.dispatcherFactory = props.getProperty("dispatcher.factory", this.dispatcherFactory);
        this.requesterFactory = props.getProperty("requester.factory", this.requesterFactory);
        this.messageReceiver = props.getProperty("message.receiver", this.messageReceiver);
        this.transactedMessageReceiver = props.getProperty("transacted.message.receiver", this.transactedMessageReceiver);
        this.xaTransactedMessageReceiver = props.getProperty("xa.transacted.message.receiver", this.xaTransactedMessageReceiver);
        this.messageAdapter = props.getProperty("message.adapter", this.messageAdapter);
        String temp = props.getProperty("inbound.transformer");
        if (temp != null) {
            this.defaultInboundTransformer = temp;
            this.inboundTransformer = null;
        }
        if ((temp = props.getProperty("outbound.transformer")) != null) {
            this.defaultOutboundTransformer = temp;
            this.outboundTransformer = null;
        }
        if ((temp = props.getProperty("response.transformer")) != null) {
            this.defaultResponseTransformer = temp;
            this.responseTransformer = null;
        }
        if ((temp = props.getProperty("endpoint.builder")) != null) {
            this.endpointBuilder = temp;
        }
    }

    public MessageAdapter createMessageAdapter(Object message) throws TransportServiceException {
        return this.createMessageAdapter(message, this.messageAdapter);
    }

    protected MessageAdapter createMessageAdapter(Object message, String clazz) throws TransportServiceException {
        if (message == null) {
            message = NullPayload.getInstance();
        }
        if (this.messageAdapter != null) {
            try {
                return (MessageAdapter)ClassUtils.instanciateClass(clazz, new Object[]{message});
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", clazz), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Adapter", this.getService()));
    }

    public SessionHandler createSessionHandler() throws TransportServiceException {
        if (this.sessionHandler == null) {
            this.sessionHandler = MuleSessionHandler.class.getName();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No session.handler set in service description, defaulting to: " + this.sessionHandler));
            }
        }
        try {
            return (SessionHandler)ClassUtils.instanciateClass(this.sessionHandler, ClassUtils.NO_ARGS, this.getClass());
        }
        catch (Throwable e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("SessionHandler", this.sessionHandler), e);
        }
    }

    public MessageReceiver createMessageReceiver(Connector connector, Service service, ImmutableEndpoint endpoint) throws MuleException {
        return this.createMessageReceiver(connector, service, endpoint, null);
    }

    public MessageReceiver createMessageReceiver(Connector connector, Service service, ImmutableEndpoint endpoint, Object[] args) throws MuleException {
        String receiverClass = this.messageReceiver;
        if (endpoint.getTransactionConfig() != null && endpoint.getTransactionConfig().getAction() != 0) {
            boolean xaTx = endpoint.getTransactionConfig().getFactory() instanceof XaTransactionFactory;
            if (this.transactedMessageReceiver != null && !xaTx) {
                receiverClass = this.transactedMessageReceiver;
            } else if (this.xaTransactedMessageReceiver != null && xaTx) {
                receiverClass = this.xaTransactedMessageReceiver;
            }
        }
        if (receiverClass != null) {
            Object[] newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, service, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                return (MessageReceiver)ClassUtils.instanciateClass(receiverClass, newArgs);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getService()), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Receiver", this.getService()));
    }

    public MessageDispatcherFactory createDispatcherFactory() throws TransportServiceException {
        if (this.dispatcherFactory != null) {
            try {
                return (MessageDispatcherFactory)ClassUtils.instanciateClass(this.dispatcherFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Dispatcher Factory", this.dispatcherFactory), (Throwable)e);
            }
        }
        return null;
    }

    public MessageRequesterFactory createRequesterFactory() throws TransportServiceException {
        if (this.requesterFactory != null) {
            try {
                return (MessageRequesterFactory)ClassUtils.instanciateClass(this.requesterFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Requester Factory", this.requesterFactory), (Throwable)e);
            }
        }
        return null;
    }

    public TransactionFactory createTransactionFactory() throws TransportServiceException {
        if (this.transactionFactory != null) {
            try {
                return (TransactionFactory)ClassUtils.instanciateClass(this.transactionFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Transaction Factory", this.transactionFactory), (Throwable)e);
            }
        }
        return null;
    }

    public Connector createConnector() throws TransportServiceException {
        Connector newConnector;
        block6: {
            try {
                if (this.connectorFactory != null) {
                    ObjectFactory factory = (ObjectFactory)ClassUtils.loadClass(this.connectorFactory, TransportFactory.class).newInstance();
                    newConnector = (Connector)factory.getOrCreate();
                    break block6;
                }
                if (this.connector != null) {
                    newConnector = (Connector)ClassUtils.loadClass(this.connector, TransportFactory.class).newInstance();
                    break block6;
                }
                throw new TransportServiceException(CoreMessages.objectNotSetInService("Connector", this.getService()));
            }
            catch (TransportServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Connector", this.connector), (Throwable)e);
            }
        }
        if (newConnector.getName() == null) {
            newConnector.setName("_" + newConnector.getProtocol() + "Connector#" + this.connector.hashCode());
        }
        return newConnector;
    }

    public List createInboundTransformers() throws TransportFactoryException {
        if (this.inboundTransformer != null) {
            return CollectionUtils.singletonList(this.inboundTransformer);
        }
        if (this.defaultInboundTransformer != null) {
            this.logger.info((Object)("Loading default inbound transformer: " + this.defaultInboundTransformer));
            try {
                this.inboundTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultInboundTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.inboundTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("inbound", this.defaultInboundTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public List createOutboundTransformers() throws TransportFactoryException {
        if (this.outboundTransformer != null) {
            return CollectionUtils.singletonList(this.outboundTransformer);
        }
        if (this.defaultOutboundTransformer != null) {
            this.logger.info((Object)("Loading default outbound transformer: " + this.defaultOutboundTransformer));
            try {
                this.outboundTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultOutboundTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.outboundTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("outbound", this.defaultOutboundTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public List createResponseTransformers() throws TransportFactoryException {
        if (this.responseTransformer != null) {
            return CollectionUtils.singletonList(this.responseTransformer);
        }
        if (this.defaultResponseTransformer != null) {
            this.logger.info((Object)("Loading default response transformer: " + this.defaultResponseTransformer));
            try {
                this.responseTransformer = (Transformer)ClassUtils.instanciateClass(this.defaultResponseTransformer, ClassUtils.NO_ARGS);
                return CollectionUtils.singletonList(this.responseTransformer);
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("response", this.defaultResponseTransformer), (Throwable)e);
            }
        }
        return TransformerUtils.UNDEFINED;
    }

    public EndpointURIBuilder createEndpointBuilder() throws TransportFactoryException {
        if (this.endpointBuilder == null) {
            this.logger.debug((Object)("Endpoint resolver not set, Loading default resolver: " + UrlEndpointURIBuilder.class.getName()));
            return new UrlEndpointURIBuilder();
        }
        this.logger.debug((Object)("Loading endpointUri resolver: " + this.endpointBuilder));
        try {
            return (EndpointURIBuilder)ClassUtils.instanciateClass(this.endpointBuilder, ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToLoad("Endpoint Builder: " + this.endpointBuilder), (Throwable)e);
        }
    }

    public void setExceptionMappings(Properties props) {
        this.exceptionMappings = props;
    }

    public Properties getExceptionMappings() {
        return this.exceptionMappings;
    }
}

